/*
 * Decompiled with CFR 0.152.
 */
package Auditing;

import Auditing.RemoteAuditSender;
import DataStructures.WorkQueue;
import DateUtilities.DateStringBuilder;
import HttpUtilities.HttpClient;
import HttpUtilities.UriBuilder;
import Notification.NotificationType;
import Notification.Notifier;
import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

class RemoteAuditWorker
extends Thread {
    private static final String SERVLET_PATH = "/Auditing/Auditing.AuditServlet";
    private static final String USER_ID_KEY = "USER_ID_KEY";
    private static final String USER_ID_VALUE = "USER_ID_VALUE";
    private static final String PATIENT_ID_KEY = "PATIENT_ID_KEY";
    private static final String PATIENT_ID_VALUE = "PATIENT_ID_VALUE";
    private static final String ACTION = "ACTION";
    private WorkQueue mAuditRequests;
    private URL mUrl;
    private Notifier mNotifier;

    public RemoteAuditWorker(URL uRL, WorkQueue workQueue, Notifier notifier) {
        super("RemoteAuditWorker: " + uRL);
        this.setDaemon(true);
        this.mAuditRequests = workQueue;
        this.mNotifier = notifier;
        try {
            this.mUrl = new URL(uRL, SERVLET_PATH);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException.toString());
        }
    }

    public void run() {
        while (true) {
            RemoteAuditSender.AuditMessage auditMessage = null;
            try {
                Object object = this.mAuditRequests.getWork();
                if (object == WorkQueue.SHUTDOWN_CONSUMER) break;
                auditMessage = (RemoteAuditSender.AuditMessage)object;
                this.postAuditMessageHttp(auditMessage);
            }
            catch (Exception exception) {
                String string = "Error auditing: " + auditMessage;
                DebugManager.getDefault().printException(string, exception);
                this.mNotifier.notifyMajorOnlyOnce(DateStringBuilder.getCurrentDateAndHour(), string, NotificationType.NETWORK, "AUDITING_10");
            }
        }
    }

    private void postAuditMessageHttp(RemoteAuditSender.AuditMessage auditMessage) {
        UriBuilder uriBuilder = new UriBuilder();
        uriBuilder.addParameter(USER_ID_KEY, auditMessage.getUserIdKey());
        uriBuilder.addParameter(USER_ID_VALUE, auditMessage.getUserIdValue());
        uriBuilder.addParameter(PATIENT_ID_KEY, auditMessage.getPatientIdKey());
        uriBuilder.addParameter(PATIENT_ID_VALUE, auditMessage.getPatientIdValue());
        uriBuilder.addParameter(ACTION, auditMessage.getAction().getHttpName());
        this.postHttp(uriBuilder);
    }

    private void postHttp(UriBuilder uriBuilder) {
        Debug debug = DebugManager.getDefault();
        String string = uriBuilder.getQuery();
        try {
            String string2 = HttpClient.sendPostRequest(this.mUrl, string);
            if (string2.equals("OK")) {
                debug.printTrace("Audit message successfully sent");
            } else {
                debug.printWarning("Audit failed: server response = " + string2);
            }
        }
        catch (IOException iOException) {
            debug.printException("Error sending remote audit to " + this.mUrl, iOException);
        }
    }
}

