/*
 * Decompiled with CFR 0.152.
 */
package DataModels.SearchFramework;

import DataModels.SearchFramework.Clause;
import DataModels.SearchFramework.Match;
import DataModels.SearchFramework.Operator;
import DataModels.SearchFramework.Term;
import Databases.Column;
import RuntimeTool.DebugManager;
import StringUtilities.StringEscape;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MatchConvertor {
    private final boolean mFullColumnNames;

    public MatchConvertor() {
        this(false);
    }

    protected MatchConvertor(boolean bl2) {
        this.mFullColumnNames = bl2;
    }

    public String toSql(Match match) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = match.getNumberOfClauses() > 1;
        Iterator iterator = match.clauseIterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            String string = this.toSql(clause);
            if (bl2) {
                stringBuffer.append("( ");
                stringBuffer.append(string);
                stringBuffer.append(" )");
            } else {
                stringBuffer.append(string);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" or ");
        }
        return stringBuffer.toString();
    }

    public String toSql(Clause clause) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = clause.getNumberOfTerms() > 1;
        Iterator iterator = clause.termIterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            String string = this.toSql(term);
            if (bl2) {
                stringBuffer.append("( ");
                stringBuffer.append(string);
                stringBuffer.append(" )");
            } else {
                stringBuffer.append(string);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" and ");
        }
        return stringBuffer.toString();
    }

    protected Column getColumn(String string) {
        return null;
    }

    protected Class getColumnValueClass(String string) {
        return String.class;
    }

    public String toSql(Term term) {
        Operator operator = term.getOperator();
        if (Operator.TRUE == operator) {
            return this.trueToSql();
        }
        String string = this.getColumnName(term);
        Class clazz = this.getColumnValueClass(term.getAttribute());
        if (clazz == Timestamp.class || clazz == Date.class) {
            return this.toSql(operator, string, new Timestamp(term.getValueAsDate().getTime()));
        }
        if (clazz == java.sql.Date.class) {
            return this.toSql(operator, string, new java.sql.Date(term.getValueAsDate().getTime()));
        }
        if (clazz == Time.class) {
            return this.toSql(operator, string, new Time(term.getValueAsDate().getTime()));
        }
        if (clazz == String.class) {
            return this.toSql(operator, string, term.getValue());
        }
        throw new IllegalArgumentException("Unsupported value type " + clazz + " for term " + term);
    }

    private String getColumnName(Term term) {
        Column column = this.getColumn(term.getAttribute());
        if (column == null) {
            DebugManager.getDefault().printWarning("Unmapped model property: " + term.getAttribute());
            return term.getAttribute();
        }
        return this.mFullColumnNames ? column.getFullName() : column.getName();
    }

    public String toSql(Operator operator, String string, String string2) {
        if (Operator.TRUE == operator) {
            return this.trueToSql();
        }
        if (Operator.EQUALS == operator) {
            return this.equalsToSql(string, string2);
        }
        if (Operator.CONTAINSALL == operator) {
            return this.containsAllToSql(string, string2);
        }
        if (Operator.CONTAINSANY == operator) {
            return this.containsAnyToSql(string, string2);
        }
        if (Operator.CONTAINSNONE == operator) {
            return this.containsNoneToSql(string, string2);
        }
        if (Operator.BEGINS == operator) {
            return this.beginsToSql(string, string2);
        }
        if (Operator.LESSEQUAL == operator) {
            return this.lessEqualToSql(string, string2);
        }
        if (Operator.LESS == operator) {
            return this.lessToSql(string, string2);
        }
        if (Operator.GREATEREQUAL == operator) {
            return this.greaterEqualToSql(string, string2);
        }
        if (Operator.GREATER == operator) {
            return this.greaterToSql(string, string2);
        }
        if (Operator.SIMPLE_MATCH == operator) {
            return this.simpleMatch(string, string2);
        }
        if (Operator.EXACTLYIN == operator) {
            return this.exactlyInToSql(string, string2);
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator);
    }

    public String toSql(Operator operator, String string, Date date) {
        if (Operator.TRUE == operator) {
            return this.trueToSql();
        }
        if (Operator.EQUALS == operator) {
            return this.equalsToSql(string, date);
        }
        if (Operator.LESSEQUAL == operator) {
            return this.lessEqualToSql(string, date);
        }
        if (Operator.LESS == operator) {
            return this.lessToSql(string, date);
        }
        if (Operator.GREATEREQUAL == operator) {
            return this.greaterEqualToSql(string, date);
        }
        if (Operator.GREATER == operator) {
            return this.greaterToSql(string, date);
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator);
    }

    private String trueToSql() {
        return "1 = 1";
    }

    private String equalsToSql(String string, String string2) {
        return "lower( " + string + " ) = '" + string2.trim().toLowerCase() + "'";
    }

    private String equalsToSql(String string, Date date) {
        return string + " = '" + date.toString() + "'";
    }

    private String containsAllToSql(String string, String string2) {
        return this.containsToSql("and", string, string2);
    }

    private String containsToSql(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = Operator.splitOperand(string3.toLowerCase());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            stringBuffer.append("( ").append("lower( ").append(string2.trim()).append(" )").append(" like '%").append(string4.trim()).append("%'").append(" )");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ").append(string).append(" ");
        }
        return stringBuffer.toString();
    }

    private String containsAnyToSql(String string, String string2) {
        return this.containsToSql("or", string, string2);
    }

    private String containsNoneToSql(String string, String string2) {
        return "not ( " + this.containsAnyToSql(string, string2) + " )";
    }

    private String beginsToSql(String string, String string2) {
        return "lower( " + string + " ) like '" + string2.trim().toLowerCase() + "%'";
    }

    private String lessEqualToSql(String string, String string2) {
        return "lower( " + string + " ) <= '" + string2.trim().toLowerCase() + "'";
    }

    private String lessEqualToSql(String string, Date date) {
        return string + " <= '" + date.toString() + "'";
    }

    private String lessToSql(String string, String string2) {
        return "lower( " + string + " ) < '" + string2.trim().toLowerCase() + "'";
    }

    private String lessToSql(String string, Date date) {
        return string + " < '" + date.toString() + "'";
    }

    private String greaterEqualToSql(String string, String string2) {
        return "lower( " + string + " ) >= '" + string2.trim().toLowerCase() + "'";
    }

    private String greaterEqualToSql(String string, Date date) {
        return string + " >= '" + date.toString() + "'";
    }

    private String greaterToSql(String string, String string2) {
        return "lower( " + string + " ) > '" + string2.trim().toLowerCase() + "'";
    }

    private String greaterToSql(String string, Date date) {
        return string + " > '" + date.toString() + "'";
    }

    protected String simpleMatch(String string, String string2) {
        return "lower( " + string + " ) like '" + this.convertSimpleMatchValue(string2).toLowerCase() + "' ESCAPE '\\'";
    }

    protected String convertSimpleMatchValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        List list = Operator.tokenizeSimpleMatch(string);
        Object object = list.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (string2.equals("*")) {
                stringBuffer.append("%");
                continue;
            }
            if (string2.equals("?")) {
                stringBuffer.append("_");
                continue;
            }
            String string3 = Operator.unescapeForSimpleMatch(string2);
            String string4 = StringEscape.escapeCharacters(string3, "_%[]\\", '\\');
            stringBuffer.append(StringEscape.escapeSql(string4));
        }
        object = stringBuffer.toString().trim();
        return object;
    }

    private String exactlyInToSql(String string, String string2) {
        Set set = Operator.splitOperand(string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" IN (");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            stringBuffer.append("'");
            stringBuffer.append(string3);
            stringBuffer.append("'");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

