/*
 * Decompiled with CFR 0.152.
 */
package DataModels.SearchFramework;

import StringUtilities.SplitQuoted;
import StringUtilities.StringEscape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Operator {
    private static Map mNameMap = new HashMap();
    public static final Operator TRUE = new Operator("True"){

        public boolean isTrue(String string, String string2) {
            return true;
        }
    };
    public static final Operator EQUALS = new Operator("Equals"){

        public boolean isTrue(String string, String string2) {
            return string.trim().equalsIgnoreCase(string2.trim());
        }
    };
    public static final Operator CONTAINSALL = new Operator("Contains"){

        public boolean isTrue(String string, String string2) {
            String string3 = string.toLowerCase();
            Set set = 3.splitOperand(string2.toLowerCase());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (Operator.containsWord(string3, string4)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Operator CONTAINSANY = new Operator("ContainsAny"){

        public boolean isTrue(String string, String string2) {
            String string3 = string.toLowerCase();
            Set set = 4.splitOperand(string2.toLowerCase());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (!Operator.containsWord(string3, string4)) continue;
                return true;
            }
            return false;
        }
    };
    public static final Operator CONTAINSNONE = new Operator("ContainsNone"){

        public boolean isTrue(String string, String string2) {
            return !CONTAINSANY.isTrue(string, string2);
        }
    };
    public static final Operator BEGINS = new Operator("Begins"){

        public boolean isTrue(String string, String string2) {
            return string.trim().toLowerCase().startsWith(string2.trim().toLowerCase());
        }
    };
    public static final Operator LESSEQUAL = new Operator("LessEqual"){

        public boolean isTrue(String string, String string2) {
            return string.compareTo(string2) <= 0;
        }
    };
    public static final Operator LESS = new Operator("Less"){

        public boolean isTrue(String string, String string2) {
            return string.compareTo(string2) < 0;
        }
    };
    public static final Operator GREATEREQUAL = new Operator("GreaterEqual"){

        public boolean isTrue(String string, String string2) {
            return string.compareTo(string2) >= 0;
        }
    };
    public static final Operator GREATER = new Operator("Greater"){

        public boolean isTrue(String string, String string2) {
            return string.compareTo(string2) > 0;
        }
    };
    public static final Operator SIMPLE_MATCH = new Operator("SimpleMatch"){

        public boolean isTrue(String string, String string2) {
            throw new UnsupportedOperationException("SIMPLE_MATCH operator not implemented");
        }
    };
    public static final Operator EXACTLYIN = new Operator("ExactlyIn"){

        public boolean isTrue(String string, String string2) {
            throw new UnsupportedOperationException("EXACTLYIN operator not implemented");
        }
    };
    private String mName;

    public static Operator createNoLogicOperator(String string) {
        Operator operator = (Operator)mNameMap.get(string);
        if (operator != null) {
            return operator;
        }
        return new Operator(string, false){

            public boolean isTrue(String string, String string2) {
                return false;
            }
        };
    }

    private Operator(String string, boolean bl2) {
        this.mName = string;
        if (bl2) {
            mNameMap.put(string, this);
        }
    }

    private Operator(String string) {
        this(string, true);
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return this.mName;
    }

    public static Operator fromString(String string) {
        return (Operator)mNameMap.get(string);
    }

    public abstract boolean isTrue(String var1, String var2);

    public static Set splitOperand(String string) {
        SplitQuoted splitQuoted = new SplitQuoted('\"');
        return new HashSet(splitQuoted.split(string));
    }

    public static String joinOperand(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\"" + iterator.next() + "\"");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return new String(stringBuffer);
    }

    private static boolean containsWord(String string, String string2) {
        return string != null && string.indexOf(string2) >= 0;
    }

    public static List tokenizeSimpleMatch(String string) {
        return new SimpleMatchTokenizer(string).getTokens();
    }

    public static String escapeForSimpleMatch(String string) {
        return StringEscape.escapeCharacters(string, "\\*?", '\\');
    }

    public static String unescapeForSimpleMatch(String string) {
        return StringEscape.unescapeCharacters(string, "\\*?", '\\');
    }

    private static class SimpleMatchTokenizer {
        private final String mInputString;
        private int mPosition = 0;
        private List mTokens = new ArrayList(100);
        private StringBuffer mCurrentToken;

        private SimpleMatchTokenizer(String string) {
            this.mInputString = string;
        }

        public List getTokens() {
            if (this.mInputString.length() == 0) {
                return this.mTokens;
            }
            block4: while (true) {
                if (this.mPosition >= this.mInputString.length()) {
                    this.endPreviousToken();
                    return this.mTokens;
                }
                switch (this.getCurrentChar()) {
                    case '\\': {
                        this.addToCurrentToken(this.getCurrentChar());
                        ++this.mPosition;
                        this.addToCurrentToken(this.getCurrentChar());
                        ++this.mPosition;
                        continue block4;
                    }
                    case '*': 
                    case '?': {
                        this.endPreviousToken();
                        this.addToCurrentToken(this.getCurrentChar());
                        ++this.mPosition;
                        this.endPreviousToken();
                        continue block4;
                    }
                }
                this.addToCurrentToken(this.getCurrentChar());
                ++this.mPosition;
            }
        }

        public char getCurrentChar() {
            if (this.mPosition >= this.mInputString.length()) {
                throw new IllegalStateException("Bad String");
            }
            return this.mInputString.charAt(this.mPosition);
        }

        public void addToCurrentToken(char c2) {
            if (this.mCurrentToken == null) {
                this.mCurrentToken = new StringBuffer();
            }
            this.mCurrentToken.append(c2);
        }

        public void endPreviousToken() {
            if (this.mCurrentToken != null) {
                this.mTokens.add(new String(this.mCurrentToken).trim());
            }
            this.mCurrentToken = null;
        }
    }
}

