/*
 * Decompiled with CFR 0.152.
 */
package DataModels.SearchFramework;

import DataModels.SearchFramework.ReferencedImageLocator;
import StringUtilities.StringCheck;

public abstract class SeriesLocation {
    public static final InstanceAvailability OFFLINE = new InstanceAvailability("OFFLINE");
    public static final InstanceAvailability ONLINE = new InstanceAvailability("ONLINE");
    public static final InstanceAvailability UNAVAILABLE = new InstanceAvailability("UNAVAILABLE");
    public static final InstanceAvailability NEARLINE = new InstanceAvailability("NEARLINE");
    private final String mSeriesUid;
    private ReferencedImageLocator mReferencedImageProvider;
    private final InstanceAvailability mAvailability;

    public SeriesLocation(String string) {
        this(string, null);
    }

    public SeriesLocation(String string, InstanceAvailability instanceAvailability) {
        if (StringCheck.isStringEmpty(string)) {
            throw new IllegalArgumentException("Series instance UID must not be empty");
        }
        this.mSeriesUid = string;
        this.mAvailability = instanceAvailability == null ? ONLINE : instanceAvailability;
    }

    public String getSeriesUid() {
        return this.mSeriesUid;
    }

    public ReferencedImageLocator getReferencedImageLocator() {
        return this.mReferencedImageProvider;
    }

    public void setReferencedImageLocator(ReferencedImageLocator referencedImageLocator) {
        this.mReferencedImageProvider = referencedImageLocator;
    }

    public final InstanceAvailability getAvailability() {
        return this.mAvailability;
    }

    public static class InstanceAvailability {
        private final String mAvailability;

        private InstanceAvailability(String string) {
            this.mAvailability = string;
        }

        public String toString() {
            return this.mAvailability;
        }
    }
}

