/*
 * Decompiled with CFR 0.152.
 */
package DataModels.UserModels;

import DataModels.UserModels.Privilege;
import DataModels.UserModels.User;
import StringUtilities.ToString;
import com.intelerad.tools.lib.RandomSource;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Session {
    public static final String WEB_SESSION = "web";
    public static final String DESKTOP_SESSION = "desktop";
    public static final String EXTERNAL_SESSION = "external";
    private static final Set mSessionTypes = new HashSet();
    private String mSessionId;
    private int mUserId;
    private String mUsername;
    private String mExternalUser;
    private User mUser;
    private String mDatabaseHost;
    private String mSessionType;
    private Date mCreateTime;
    private Date mAccessTime;
    private int mTimeout = -1;
    private String mClientName;
    private String mHostIpAddress;
    private String mHostMacAddress;
    private String mAeTitle;
    private static SimpleDateFormat mDateFormatter;

    Session() {
    }

    public Session(User user, String string, String string2) {
        this.setUser(user);
        this.mSessionId = string;
        this.mDatabaseHost = string2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Session)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Session session = (Session)object;
        return this.mSessionId.equals(session.mSessionId) && this.mUsername.equals(session.mUsername) && this.mUser.equals(session.mUser);
    }

    public int hashCode() {
        return this.mSessionId.hashCode() ^ this.mUsername.hashCode() ^ this.mUser.hashCode();
    }

    public String toString() {
        return ToString.object(this, true, this.mSessionId);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println(this.toString());
        printWriter.println("  username: " + this.mUsername + " (user: " + this.mUser + ")");
        printWriter.println("  session type: " + this.mSessionType);
        printWriter.println("  create time: " + Session.formatDate(this.mCreateTime));
        printWriter.println("  access time: " + Session.formatDate(this.mAccessTime));
        printWriter.println("  timeout: " + this.mTimeout + " (expire time: " + Session.formatDate(this.getExpireTime()) + ")");
        printWriter.println("  host IP addr: " + this.mHostIpAddress);
        printWriter.println("  host MAC addr: " + this.mHostMacAddress);
        printWriter.println("  AE title: " + this.mAeTitle);
        printWriter.println("  database host: " + this.mDatabaseHost);
    }

    public void update(Session session) {
        this.mSessionId = session.mSessionId;
        this.mUsername = session.mUsername;
        this.mUser = session.mUser;
        this.mDatabaseHost = session.mDatabaseHost;
        this.mSessionType = session.mSessionType;
        this.mCreateTime = session.mCreateTime;
        this.mAccessTime = session.mAccessTime;
        this.mTimeout = session.mTimeout;
        this.mClientName = session.mClientName;
        this.mHostIpAddress = session.mHostIpAddress;
        this.mHostMacAddress = session.mHostMacAddress;
        this.mAeTitle = session.mAeTitle;
    }

    public void generateSessionId() {
        this.mSessionId = RandomSource.getInstance().encodeBytes(16);
    }

    public void setUserId(int n2) {
        this.mUserId = n2;
    }

    public void setUsername(String string) {
        this.mUsername = string;
    }

    public void setExternalUser(String string) {
        if (!this.mSessionType.equals(EXTERNAL_SESSION) && string != null) {
            throw new IllegalStateException(this + ": not an external session -- cannot set external user to '" + string + "'");
        }
        this.mExternalUser = string;
    }

    public void setUser(User user) {
        this.mUser = user;
        if (user != null) {
            this.mUsername = user.getUsername();
            this.mUserId = user.getUserId();
        }
    }

    public void setSessionType(String string) {
        if (!mSessionTypes.contains(string)) {
            throw new IllegalArgumentException("invalid session type: " + string);
        }
        this.mSessionType = string;
    }

    public void setCreateTime(Date date) {
        this.mCreateTime = date;
    }

    public void setAccessTime(Date date) {
        this.mAccessTime = date;
    }

    public void updateAccessTime() {
        this.mAccessTime = new Date();
    }

    public void setTimeout(int n2) {
        this.mTimeout = n2;
    }

    public void setClientName(String string) {
        this.mClientName = string;
    }

    public void setHostIpAddress(String string) {
        this.mHostIpAddress = string;
    }

    public void setHostMacAddress(String string) {
        this.mHostMacAddress = string;
    }

    public void setAeTitle(String string) {
        this.mAeTitle = string;
    }

    public boolean matchesUsername(String string) {
        return string != null && this.mUsername != null && this.mUsername.equals(string);
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getExternalUser() {
        return this.mExternalUser;
    }

    public User getUser() {
        return this.mUser;
    }

    public boolean isAuthenticated() {
        return this.mUser != null;
    }

    public String getSessionType() {
        return this.mSessionType;
    }

    public boolean isWebSession() {
        return this.mSessionType.equals(WEB_SESSION);
    }

    public boolean isDesktopSession() {
        return this.mSessionType.equals(DESKTOP_SESSION);
    }

    public boolean isExternalSession() {
        return this.mSessionType.equals(EXTERNAL_SESSION);
    }

    public Date getCreateTime() {
        return this.mCreateTime;
    }

    public String formatCreateTime() {
        return Session.formatDate(this.mCreateTime);
    }

    public Date getAccessTime() {
        return this.mAccessTime;
    }

    public String formatAccessTime() {
        return Session.formatDate(this.mAccessTime);
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public Date getExpireTime() {
        if (this.mAccessTime == null || this.mTimeout == -1) {
            return null;
        }
        return new Date(this.mAccessTime.getTime() + (long)(this.mTimeout * 1000));
    }

    public boolean isExpired() {
        Date date = this.getExpireTime();
        if (date == null) {
            return false;
        }
        return new Date().after(date);
    }

    public String getClientName() {
        return this.mClientName;
    }

    public String getHostIpAddress() {
        return this.mHostIpAddress;
    }

    public String getHostMacAddress() {
        return this.mHostMacAddress;
    }

    public String getAeTitle() {
        return this.mAeTitle;
    }

    public String getDatabaseHost() {
        return this.mDatabaseHost;
    }

    public boolean isValid(String string) {
        return this.matchesUsername(string) && this.mUser != null && !this.isExpired() && this.mUser.isValid();
    }

    public boolean userHasPrivilege(Privilege privilege) {
        return this.mUser != null && this.mUser.hasPrivilege(privilege);
    }

    public void checkSave() {
        if (this.mUser == null) {
            throw new IllegalStateException("cannot save session: mUser == null");
        }
        if (this.mUsername == null) {
            throw new IllegalStateException("cannot save session: mUsername == null");
        }
        if (this.mSessionId == null) {
            throw new IllegalStateException("cannot save session: mSessionId == null");
        }
        if (this.mSessionType == null) {
            throw new IllegalStateException("cannot save session: mSessionType == null");
        }
        if (this.mTimeout == -1) {
            throw new IllegalStateException("cannot save session: mTimeout == -1");
        }
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return mDateFormatter.format(date);
    }

    public static String getSessionId(Session session) {
        return session == null ? null : session.getSessionId();
    }

    public static Session createSession(User user, String string) {
        Session session = new Session(user, string, null);
        if (string == null) {
            session.generateSessionId();
        }
        Date date = new Date();
        session.setCreateTime(date);
        session.setAccessTime(date);
        return session;
    }

    static {
        mSessionTypes.add(WEB_SESSION);
        mSessionTypes.add(DESKTOP_SESSION);
        mSessionTypes.add(EXTERNAL_SESSION);
        mDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

