/*
 * Decompiled with CFR 0.152.
 */
package DataModels;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    private final PropertyChangeSupport mPropertySupport;
    private final String mPropertyName;
    private final WeakReference mListenerReference;

    public WeakPropertyChangeListener(PropertyChangeListener propertyChangeListener, PropertyChangeSupport propertyChangeSupport) {
        this(null, propertyChangeListener, propertyChangeSupport);
    }

    public WeakPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener, PropertyChangeSupport propertyChangeSupport) {
        this.mPropertySupport = propertyChangeSupport;
        this.mPropertyName = string;
        this.mListenerReference = new WeakReference<PropertyChangeListener>(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.mListenerReference.get();
        if (propertyChangeListener != null) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        } else {
            this.mPropertySupport.removePropertyChangeListener(this);
            if (this.mPropertyName != null) {
                this.mPropertySupport.removePropertyChangeListener(this.mPropertyName, this);
            }
        }
    }

    public WeakReference getListenerReference() {
        return this.mListenerReference;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }
}

