/*
 * Decompiled with CFR 0.152.
 */
package DataModels;

import DataModels.DataModel;
import DataModels.ModelProperty;
import DataModels.ObservableDataModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WrappedDataModel
extends ObservableDataModel {
    private DataModel mWrappedModel;
    private Set mWrappedProperties;
    private Map mLocalStorage;

    public WrappedDataModel(DataModel dataModel) {
        this.mWrappedModel = dataModel;
        this.mWrappedProperties = new HashSet();
        this.mWrappedProperties.addAll(dataModel.getProperties());
        this.mLocalStorage = new HashMap();
    }

    public void setProperty(ModelProperty modelProperty, Object object) throws IllegalArgumentException {
        Object object2 = this.getProperty(modelProperty);
        if (this.mWrappedProperties.contains(modelProperty)) {
            this.mWrappedModel.setProperty(modelProperty, object);
        } else {
            this.mLocalStorage.put(modelProperty, object);
        }
        this.firePropertyChange(modelProperty, object2);
    }

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        if (this.mWrappedProperties.contains(modelProperty)) {
            return this.mWrappedModel.getProperty(modelProperty);
        }
        return this.mLocalStorage.get(modelProperty);
    }

    public Collection getProperties() {
        ArrayList arrayList = new ArrayList(this.mLocalStorage.keySet());
        arrayList.addAll(this.mWrappedProperties);
        return arrayList;
    }
}

