/*
 * Decompiled with CFR 0.152.
 */
package DataStructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.IteratorChain;

public final class CollectionUtilities {
    public static final Transformer NULL_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            return object;
        }
    };

    public static Map inverseMap(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (hashMap.containsKey(entry.getValue())) {
                throw new IllegalArgumentException("Non-invertible map, contains duplicate value: " + entry.getValue());
            }
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public static Map composeMaps(Map map, Map map2) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!map2.containsKey(entry.getValue())) continue;
            hashMap.put(entry.getKey(), map2.get(entry.getValue()));
        }
        return hashMap;
    }

    public static List collect(Collection collection, Transformer transformer) {
        return (List)CollectionUtils.collect((Collection)collection, (Transformer)transformer);
    }

    public static List collectIgnoreNull(Collection collection, Transformer transformer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = transformer.transform(iterator.next());
            if (object == null) continue;
            arrayList.add(object);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public static List filter(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection);
        CollectionUtils.filter(arrayList, (Predicate)predicate);
        arrayList.trimToSize();
        return arrayList;
    }

    public static Map filter(Map map, Predicate predicate) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!predicate.evaluate(entry)) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static Iterator getIteratorChain(Collection collection) {
        Transformer transformer = new Transformer(){

            public Object transform(Object object) {
                return ((Collection)object).iterator();
            }
        };
        return new IteratorChain((Collection)CollectionUtilities.collect(collection, transformer));
    }

    public static List flatten(Collection collection) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll((Collection)iterator.next());
        }
        return new ArrayList(linkedList);
    }

    public static List unflatten(List list, List list2) {
        ArrayList arrayList = new ArrayList(list.size());
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            ArrayList arrayList2 = new ArrayList(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                arrayList2.add(list2.get(n2));
                ++n2;
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static Map createMap(List list, Transformer transformer, Transformer transformer2) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object object = transformer.transform(e2);
            Object object2 = transformer2.transform(e2);
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    public static Map groupRelated(List list, Transformer transformer, Transformer transformer2) {
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object object = transformer.transform(e2);
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(object, arrayList);
            }
            arrayList.add(transformer2.transform(e2));
        }
        return hashMap;
    }

    public static List sort(List list, Comparator comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        list = Arrays.asList(objectArray);
        return list;
    }

    public static class EntryValuePredicate
    implements Predicate {
        private final Predicate mValuePredicate;

        public EntryValuePredicate(Predicate predicate) {
            this.mValuePredicate = predicate;
        }

        public boolean evaluate(Object object) {
            return object != null && this.mValuePredicate.evaluate(((Map.Entry)object).getValue());
        }
    }

    public static class EntryKeyPredicate
    implements Predicate {
        private final Predicate mKeyPredicate;

        public EntryKeyPredicate(Predicate predicate) {
            this.mKeyPredicate = predicate;
        }

        public boolean evaluate(Object object) {
            return object != null && this.mKeyPredicate.evaluate(((Map.Entry)object).getKey());
        }
    }

    public static class NotPredicate
    implements Predicate {
        private final Predicate mPredicate;

        public NotPredicate(Predicate predicate) {
            this.mPredicate = predicate;
        }

        public boolean evaluate(Object object) {
            return !this.mPredicate.evaluate(object);
        }
    }

    public static class InstanceOfPredicate
    implements Predicate {
        private final Class mClass;

        public InstanceOfPredicate(Class clazz) {
            this.mClass = clazz;
        }

        public boolean evaluate(Object object) {
            return this.mClass.isInstance(object);
        }
    }
}

