/*
 * Decompiled with CFR 0.152.
 */
package DateUtilities;

import DateUtilities.DateUtilities;
import RuntimeTool.Debug;
import StringUtilities.StringConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateExtractor {
    private static final String mDebugKey = "DateExtractor";
    private static final Date INVALID_DATE_TIME = new GregorianCalendar(1, 0, 1).getTime();
    private int mYear = -1;
    private int mMonth = -1;
    private int mDay = -1;
    private int mHour = -1;
    private int mMinute = -1;
    private int mSecond = -1;
    private boolean mOnlyDateSpecified = false;
    private Debug mDebug = null;

    public DateExtractor() {
    }

    public DateExtractor(Debug debug) {
        this();
        this.mDebug = debug;
    }

    public static String getDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        return simpleDateFormat.format(date);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] extractFields(String string) {
        try {
            if (string == null) {
                return null;
            }
            if (string.length() == 12) {
                string = string + "00";
            }
            int[] nArray = new int[7];
            if (string.length() >= 14) {
                nArray[3] = Integer.parseInt(string.substring(8, 10));
                nArray[4] = Integer.parseInt(string.substring(10, 12));
                nArray[5] = Integer.parseInt(string.substring(12, 14));
                if (string.length() >= 15) {
                    if (!string.substring(14, 15).equals(".")) throw new IllegalArgumentException("Inputs with more than 14 characters require a '.' to separate the fractional component of seconds. I got (" + string + "), with length: " + string.length());
                    nArray[6] = Integer.parseInt(string.substring(16));
                }
            } else if (string.length() != 8) {
                throw new IllegalArgumentException("Input should be 8, 12 or at least 14 characters in length. I got (" + string + "), with length: " + string.length());
            }
            nArray[0] = Integer.parseInt(string.substring(0, 4));
            nArray[1] = Integer.parseInt(string.substring(4, 6));
            nArray[2] = Integer.parseInt(string.substring(6, 8));
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to parse input (" + string + ") with length: " + string.length() + ". Got a NumberFormatException " + numberFormatException);
            illegalArgumentException.setStackTrace(numberFormatException.getStackTrace());
            throw illegalArgumentException;
        }
    }

    public static int[] extractTimeSinceMidnight(String string) {
        int[] nArray;
        double d2;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        nArray = new int[]{(int)(d2 / 3600.0), (int)((d2 - (double)(nArray[0] * 3600)) / 60.0), (int)(d2 - (double)(nArray[0] * 3600) - (double)(nArray[1] * 60))};
        return nArray;
    }

    public void setDateToParse(String string) {
        this.mSecond = -1;
        this.mMinute = -1;
        this.mHour = -1;
        this.mDay = -1;
        this.mMonth = -1;
        this.mYear = -1;
        int[] nArray = DateExtractor.extractFields(string);
        if (nArray != null) {
            this.mYear = nArray[0];
            this.mMonth = nArray[1];
            this.mDay = nArray[2];
            this.mHour = nArray[3];
            this.mMinute = nArray[4];
            this.mSecond = nArray[5];
            this.mOnlyDateSpecified = string.length() == 8;
        } else {
            this.mDebug.print(mDebugKey, "Unable to convert dateYYYYMMDDhhmmss String = [" + string + "] into parsed date: YYYYMMDDhhmmss");
        }
    }

    public void setSecondsSinceMidnightToParse(String string) {
        this.mSecond = -1;
        this.mMinute = -1;
        this.mHour = -1;
        int[] nArray = DateExtractor.extractTimeSinceMidnight(string);
        if (nArray != null) {
            this.mHour = nArray[0];
            this.mMinute = nArray[1];
            this.mSecond = nArray[2];
        } else {
            this.mDebug.print(mDebugKey, "Unable to convert secondsSinceMidnight string = [" + string + "] into parsed time: hhmmss");
        }
    }

    public Calendar getCalendar() {
        if (this.mYear != -1 && this.mMonth != -1 && this.mDay != -1) {
            return new GregorianCalendar(this.mYear, this.getGregorianCalendarMonth(this.mMonth), this.mDay, this.mHour, this.mMinute, this.mSecond);
        }
        this.mDebug.print(mDebugKey, "mYear, mMonth, and mDay not set, unable to create GregorianCalendar");
        return null;
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDay() {
        return this.mDay;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getSecond() {
        return this.mSecond;
    }

    public String getDateOnlyStringRaw() {
        return StringConverter.getPaddedString(new Integer(this.mYear).toString(), '0', 2) + StringConverter.getPaddedString(new Integer(this.mMonth).toString(), '0', 2) + StringConverter.getPaddedString(new Integer(this.mDay).toString(), '0', 2);
    }

    public String getDateOnlyString() {
        return StringConverter.getPaddedString(new Integer(this.mYear).toString(), '0', 2) + "/" + StringConverter.getPaddedString(new Integer(this.mMonth).toString(), '0', 2) + "/" + StringConverter.getPaddedString(new Integer(this.mDay).toString(), '0', 2);
    }

    public String getTimeOnlyStringRaw() {
        return StringConverter.getPaddedString(new Integer(this.mHour).toString(), '0', 2) + StringConverter.getPaddedString(new Integer(this.mMinute).toString(), '0', 2) + StringConverter.getPaddedString(new Integer(this.mSecond).toString(), '0', 2);
    }

    public String getTimeOnlyString() {
        return StringConverter.getPaddedString(new Integer(this.mHour).toString(), '0', 2) + ":" + StringConverter.getPaddedString(new Integer(this.mMinute).toString(), '0', 2) + ":" + StringConverter.getPaddedString(new Integer(this.mSecond).toString(), '0', 2);
    }

    public String getDateString() {
        if (this.mOnlyDateSpecified) {
            return this.getDateOnlyString();
        }
        return this.getDateOnlyString() + " " + this.getTimeOnlyString();
    }

    private int getGregorianCalendarMonth(int n2) {
        if (n2 == 1) {
            return 0;
        }
        if (n2 == 2) {
            return 1;
        }
        if (n2 == 3) {
            return 2;
        }
        if (n2 == 4) {
            return 3;
        }
        if (n2 == 5) {
            return 4;
        }
        if (n2 == 6) {
            return 5;
        }
        if (n2 == 7) {
            return 6;
        }
        if (n2 == 8) {
            return 7;
        }
        if (n2 == 9) {
            return 8;
        }
        if (n2 == 10) {
            return 9;
        }
        if (n2 == 11) {
            return 10;
        }
        return 11;
    }

    public static String getSecondsSinceMidnight(String string, Debug debug) {
        if (string == null) {
            debug.printError("NULL String provided (expected a string formated as HHMMSS): returning empty String");
            return "";
        }
        try {
            long l2 = DateUtilities.parseDicomTime("000000.000").getTime();
            long l3 = DateUtilities.parseDicomTime(string).getTime();
            return "" + (l3 - l2) / 1000L;
        }
        catch (ParseException parseException) {
            debug.printError("Unable to get seconds from '" + string + "', " + parseException);
            return "";
        }
    }

    public static void testSecondsSinceMidnight(String string, String string2, boolean bl2) {
        Debug debug = new Debug("tester", "stdout", "");
        String string3 = DateExtractor.getSecondsSinceMidnight(string, debug);
        if (string3.equals("")) {
            if (bl2) {
                System.out.println("Input (" + string + ") should have worked but didn't.");
            } else {
                System.out.println("OK");
            }
        } else if (bl2) {
            if (string2.equals(string3)) {
                System.out.println("OK");
            } else {
                System.out.println("ERROR: got (" + string3 + "), expected (" + string2 + ") with input (" + string + ")");
            }
        } else {
            System.out.println("Input (" + string + ") should have not worked, but did with result: " + string3);
        }
    }

    public static boolean isDateInvalid(Date date) {
        return INVALID_DATE_TIME.equals(date);
    }

    public static Date getInvalidDate() {
        return INVALID_DATE_TIME;
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing....");
        DateExtractor.testSecondsSinceMidnight("221133", "79893", true);
        DateExtractor.testSecondsSinceMidnight("000000", "0", true);
        DateExtractor.testSecondsSinceMidnight("22113", "", false);
        DateExtractor.testSecondsSinceMidnight("ajs22", "", false);
        DateExtractor.testSecondsSinceMidnight(null, "", false);
    }
}

