/*
 * Decompiled with CFR 0.152.
 */
package DateUtilities;

import DateUtilities.DateExtractor;
import StringUtilities.PrintfFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateStringBuilder {
    static final int MAX_SECONDS_IN_DAY = 86400;

    public static String getDateTimeMs(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String getDateTimeGmtMs(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String getYyyyMmDdHhMmSsFromSecondsSinceEpoch(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l2));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getYyyyMmDdFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getIsoDateTimeFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getHhMmSsFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getCurrentDate() {
        return DateStringBuilder.getYyyyMmDdFromCalendar(Calendar.getInstance());
    }

    public static String getCurrentDateTimeIso() {
        return DateStringBuilder.getIsoDateTimeFromCalendar(Calendar.getInstance());
    }

    public static String getCurrentDateAndHour() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHH");
        return simpleDateFormat.format(Calendar.getInstance().getTime());
    }

    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string = simpleDateFormat.format(calendar.getTime());
        return string;
    }

    public static String getCurrentTimeGmtMs() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(calendar.getTime());
        return string;
    }

    public static String getCurrentTimeGmt() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(calendar.getTime());
        return string;
    }

    public static String getDateTimeWithRange(int n2, String string, String string2) throws NumberFormatException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            String string3 = string2.trim();
            String string4 = string.trim();
            int n3 = Integer.parseInt(string4.substring(0, 4));
            int n4 = Integer.parseInt(string4.substring(4, 6)) - 1;
            int n5 = Integer.parseInt(string4.substring(6, 8));
            if (string3.length() == 6) {
                calendar.set(n3, n4, n5, Integer.parseInt(string3.substring(0, 2)), Integer.parseInt(string3.substring(2, 4)), Integer.parseInt(string3.substring(4, 6)));
            } else if (string3.length() == 4) {
                calendar.set(n3, n4, n5, Integer.parseInt(string3.substring(0, 2)), Integer.parseInt(string3.substring(2, 4)));
            } else {
                calendar.set(n3, n4, n5);
            }
            calendar.set(11, calendar.get(11) + n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Date format not valid");
        }
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatDateInHtml(String string) {
        String string2 = DateStringBuilder.formatDate(string);
        if (string.length() == 8) {
            return string2;
        }
        if (string.length() == 14) {
            return string2.substring(0, 10) + "&nbsp;&nbsp;" + string2.substring(10);
        }
        return string;
    }

    public static String formatDate(String string) {
        if (!string.equals("&nbsp;") && !string.equals("N/A")) {
            String string2 = string;
            if (string.length() == 12) {
                string2 = string.substring(0, 4) + '-' + string.substring(4, 6) + '-' + string.substring(6, 8) + " " + string.substring(8, 10) + ':' + string.substring(10, 12);
            } else if (string.length() == 14) {
                string2 = string.substring(0, 4) + '-' + string.substring(4, 6) + '-' + string.substring(6, 8) + " " + string.substring(8, 10) + ':' + string.substring(10, 12) + ':' + string.substring(12, 14);
            } else if (string.length() == 17) {
                string2 = string.substring(0, 4) + '-' + string.substring(4, 6) + '-' + string.substring(6, 8) + " " + string.substring(8, 10) + ':' + string.substring(10, 12) + ':' + string.substring(12, 14) + '.' + string.substring(14, 17);
            } else if (string.length() == 8) {
                string2 = string.substring(0, 4) + '-' + string.substring(4, 6) + '-' + string.substring(6, 8);
            }
            return string2;
        }
        return string;
    }

    public static String formatDate(String string, boolean bl2) {
        String string2 = "";
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.length() == 14) {
            string2 = bl2 ? string.substring(0, 4) + "/" + string.substring(4, 6) + "/" + string.substring(6, 8) : string.substring(4, 6) + "/" + string.substring(6, 8) + "/" + string.substring(0, 4);
            string2 = string2 + " " + string.substring(8, 10) + ":" + string.substring(10, 12) + ":" + string.substring(12, 14);
        } else {
            string2 = string.length() == 8 ? (bl2 ? string.substring(0, 4) + " / " + string.substring(4, 6) + " / " + string.substring(6, 8) : string.substring(4, 6) + " / " + string.substring(6, 8) + " / " + string.substring(0, 4)) : string;
        }
        return string2;
    }

    public static String getTimeFromSecondsSiceMidnight(int n2) {
        if (n2 < 0 || n2 >= 86400) {
            throw new NumberFormatException("Seconds given outside range [0, 86400). Got [" + n2 + "]");
        }
        int n3 = n2 / 3600;
        int n4 = (n2 - n3 * 3600) / 60;
        int n5 = n2 - n3 * 3600 - n4 * 60;
        PrintfFormat printfFormat = new PrintfFormat("%02d");
        return printfFormat.sprintf(n3) + printfFormat.sprintf(n4) + printfFormat.sprintf(n5);
    }

    public static String getDateTimepartOnly(String string) {
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            n2 = string.indexOf(45);
            return n2 == -1 ? string : string.substring(0, n2);
        }
        return string.substring(0, n2);
    }

    public static String getHumanReadableDateTime(String string, Locale locale) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        Calendar calendar = Calendar.getInstance(locale);
        int[] nArray = DateExtractor.extractFields(string);
        calendar.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
        return dateFormat.format(calendar.getTime());
    }

    public static void testGetHumanReadableDateTime(String string, Locale locale, String string2) {
        String string3 = DateStringBuilder.getHumanReadableDateTime(string, locale);
        if (string3.equals(string2)) {
            System.out.println("OK");
        } else {
            System.out.println("ERROR. Expected (" + string2 + "), got (" + string3 + ")");
        }
    }

    public static void testGetDateTimePartOnly(String string, String string2) {
        String string3 = DateStringBuilder.getDateTimepartOnly(string);
        if (string3.equals(string2)) {
            System.out.println("OK");
        } else {
            System.out.println("ERROR: Got (" + string3 + "), expected (" + string2 + "), input (" + string + ")");
        }
    }

    public static void testTimeSinceMidnight(int n2, String string) {
        String string2;
        try {
            string2 = DateStringBuilder.getTimeFromSecondsSiceMidnight(n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("-1")) {
                System.out.println("OK   : Expected exception caught.");
            } else {
                System.out.println("ERROR: Uncaught NumberFormatException when expected value: " + string);
            }
            return;
        }
        if (string2.equals(string)) {
            System.out.println("OK   : " + string2);
        } else {
            System.out.println("ERROR: Got (" + string2 + "), expected (" + string + ")");
        }
    }

    public static void testDateTimeWithRange(int n2, String string, String string2, String string3) {
        String string4;
        try {
            string4 = DateStringBuilder.getDateTimeWithRange(n2, string, string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (string3.equals("-1")) {
                System.out.println("OK   : Expected exception caught.");
            } else {
                System.out.println("ERROR: Uncaught NumberFormatException when expected value: " + string3);
            }
            return;
        }
        if (string4.equals(string3)) {
            System.out.println("OK   : [" + string + "," + string2 + ":" + n2 + "]");
        } else if (string4.length() == string3.length()) {
            System.out.println("ERROR: got (" + string4 + "), expected (" + string3 + ")");
        } else if (string4.startsWith(string3) && string4.length() == string3.length() + 2) {
            System.out.println("OK   : [" + string + "," + string2 + ":" + n2 + "]");
        } else {
            System.out.println("ERROR: got (" + string4 + "), expected (" + string3 + ")");
        }
    }

    public static void testFormatDate(String string, String string2) {
        String string3 = DateStringBuilder.formatDate(string);
        if (string3.equals(string2)) {
            System.out.println("OK   : " + string3);
        } else {
            System.out.println("ERROR: got (" + string3 + "), expected (" + string2 + ")");
        }
    }

    public static void testFormatDateInHtml(String string, String string2) {
        String string3 = DateStringBuilder.formatDateInHtml(string);
        if (string3.equals(string2)) {
            System.out.println("OK   : " + string3);
        } else {
            System.out.println("ERROR: got (" + string3 + "), expected (" + string2 + ")");
        }
    }

    private static void testGetYyyyMmDdFromCalendar() {
        String string = DateStringBuilder.getYyyyMmDdFromCalendar(Calendar.getInstance());
        System.out.println("Now is: " + string);
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing....");
        System.out.println("Current Date    : " + DateStringBuilder.getCurrentDate());
        System.out.println("Current Time    : " + DateStringBuilder.getCurrentTime());
        System.out.println("Current Time GMT: " + DateStringBuilder.getCurrentTimeGmt());
        System.out.println("\nTesting getDateTimeWithRange...");
        DateStringBuilder.testDateTimeWithRange(5, "20010803", "173100", "20010803223100");
        DateStringBuilder.testDateTimeWithRange(-5, "20010803", "173100", "20010803123100");
        DateStringBuilder.testDateTimeWithRange(5, "20010803", "1731", "200108032231");
        DateStringBuilder.testDateTimeWithRange(5, "200108wre3", "173100", "-1");
        DateStringBuilder.testDateTimeWithRange(5, "200108wre3", "1731xx", "-1");
        DateStringBuilder.testDateTimeWithRange(10, "20010812", "173121", "20010813033121");
        System.out.println("\nTesting getTimeFromSecondsSiceMidnight...");
        DateStringBuilder.testTimeSinceMidnight(33, "000033");
        DateStringBuilder.testTimeSinceMidnight(-33, "-1");
        DateStringBuilder.testTimeSinceMidnight(0, "000000");
        DateStringBuilder.testTimeSinceMidnight(86400, "-1");
        DateStringBuilder.testTimeSinceMidnight(86401, "-1");
        DateStringBuilder.testTimeSinceMidnight(86399, "235959");
        System.out.println("\nTesting formatDate...");
        DateStringBuilder.testFormatDate("33", "33");
        DateStringBuilder.testFormatDate("20021112102512", "2002-11-12 10:25:12");
        DateStringBuilder.testFormatDate("200211121025", "2002-11-12 10:25");
        DateStringBuilder.testFormatDate("20021224", "2002-12-24");
        DateStringBuilder.testFormatDate("20021224143422876", "2002-12-24 14:34:22.876");
        System.out.println("\nTesting formatDateInHtml...");
        DateStringBuilder.testFormatDateInHtml("33", "33");
        DateStringBuilder.testFormatDateInHtml("20021112102512", "2002-11-12&nbsp;&nbsp; 10:25:12");
        DateStringBuilder.testFormatDateInHtml("20021224", "2002-12-24");
        System.out.println("\nTesting testGetDateTimePartOnly...");
        DateStringBuilder.testGetDateTimePartOnly("20020509130700.0000-0700", "20020509130700");
        DateStringBuilder.testGetDateTimePartOnly("20020509130700-0700", "20020509130700");
        DateStringBuilder.testGetDateTimePartOnly("20020509130700", "20020509130700");
        System.out.println("\nTesting testGetHumanReadableDateTime...");
        DateStringBuilder.testGetHumanReadableDateTime("20021009103332", new Locale("en", "us"), "Oct 9, 2002 10:33:32 AM");
        DateStringBuilder.testGetHumanReadableDateTime("20021009103332", new Locale("en", "ca"), "9-Oct-02 10:33:32 AM");
        DateStringBuilder.testGetHumanReadableDateTime("20021009103332", new Locale("fr", "ca"), "02-10-09 10:33:32");
        DateStringBuilder.testGetHumanReadableDateTime("20021009103332", new Locale("fr", "fr"), "9 oct. 02 10:33:32");
        DateStringBuilder.testGetHumanReadableDateTime("20021231", new Locale("en", "us"), "Dec 31, 2002 12:00:00 AM");
        System.out.println("\nTesting getYyyyMmDdFromCalendar...");
        DateStringBuilder.testGetYyyyMmDdFromCalendar();
    }
}

