/*
 * Decompiled with CFR 0.152.
 */
package FileUtilities;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListFiles {
    public static List getAllFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length < 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file2 = fileArray[i2];
            if (file2.isDirectory()) {
                arrayList.addAll(ListFiles.getAllFiles(file2));
                continue;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static List listAllFiles(File file, FileFilter fileFilter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileFilter != null && !fileFilter.accept(fileArray[i2])) continue;
            if (fileArray[i2].isFile()) {
                arrayList.add(fileArray[i2].getAbsolutePath());
                continue;
            }
            if (!fileArray[i2].isDirectory()) continue;
            arrayList.addAll(ListFiles.listAllFiles(fileArray[i2], fileFilter));
        }
        return arrayList;
    }

    public static File[] listFiles(File[] fileArray, FilenameFilter filenameFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            arrayList.addAll(Arrays.asList(fileArray[i2].listFiles(filenameFilter)));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static File[] listFiles(File[] fileArray, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            arrayList.addAll(Arrays.asList(fileArray[i2].listFiles(fileFilter)));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private ListFiles() {
    }
}

