/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.DataModels;

import DataModels.DataModel;
import DataModels.ModelProperty;
import GuiUtilities.DataModels.ButtonChangeListener;
import GuiUtilities.DataModels.ButtonSelectorChangeListener;
import GuiUtilities.DataModels.ComboBoxChangeListener;
import GuiUtilities.DataModels.ComponentEnablerChangeListener;
import GuiUtilities.DataModels.LabelChangeListener;
import GuiUtilities.DataModels.ListSelectionChangeListener;
import GuiUtilities.DataModels.ModelPropertyListModel;
import GuiUtilities.DataModels.ModelPropertySpinnerModel;
import GuiUtilities.DataModels.PropertySetterAction;
import GuiUtilities.DataModels.PropertySetterActionListener;
import GuiUtilities.DataModels.PropertySetterItemListener;
import GuiUtilities.DataModels.PropertySetterKeyListener;
import GuiUtilities.DataModels.PropertySetterListSelectionListener;
import GuiUtilities.DataModels.SpinnerSetPropertyAction;
import GuiUtilities.DataModels.TextFieldChangeListener;
import GuiUtilities.DataModels.ToggleButtonChangeListener;
import GuiUtilities.DataModels.TogglePropertySetterAction;
import GuiUtilities.Util.ConstrainedTextField;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class DataModelComponentFactory {
    private static final String INTEGER_TEXT_FIELD_REGEX = "[^\\d+-]";

    public JLabel createLabel(ModelProperty modelProperty) {
        return this.createLabel(modelProperty, "");
    }

    public JLabel createLabel(ModelProperty modelProperty, String string) {
        JLabel jLabel = new JLabel(modelProperty.getDescription() + string);
        jLabel.setAlignmentX(1.0f);
        return jLabel;
    }

    public JLabel createLabel(DataModel dataModel, ModelProperty modelProperty) {
        JLabel jLabel = new JLabel(dataModel.getProperty(modelProperty).toString());
        dataModel.addPropertyChangeListener(modelProperty, new LabelChangeListener(jLabel));
        return jLabel;
    }

    public JButton createButton(DataModel dataModel, ModelProperty modelProperty, Object object) {
        return new JButton(new PropertySetterAction(dataModel, modelProperty, object));
    }

    public JCheckBox createCheckBox(DataModel dataModel, ModelProperty modelProperty, Object object, Object object2) {
        JCheckBox jCheckBox = new JCheckBox(new TogglePropertySetterAction(dataModel, modelProperty, object, object2));
        Object object3 = dataModel.getProperty(modelProperty);
        jCheckBox.setSelected(object3 != null && object3.equals(object));
        ToggleButtonChangeListener toggleButtonChangeListener = new ToggleButtonChangeListener(jCheckBox, object);
        dataModel.addWeakPropertyChangeListener(modelProperty, toggleButtonChangeListener);
        this.makeStrongReference(jCheckBox, toggleButtonChangeListener);
        return jCheckBox;
    }

    public JComboBox createComboBox(DataModel dataModel, ModelProperty modelProperty, List list) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(list.toArray());
        jComboBox.setSelectedItem(dataModel.getProperty(modelProperty));
        jComboBox.addItemListener(new PropertySetterItemListener(dataModel, modelProperty));
        ComboBoxChangeListener comboBoxChangeListener = new ComboBoxChangeListener(jComboBox);
        this.makeStrongReference(jComboBox, comboBoxChangeListener);
        dataModel.addWeakPropertyChangeListener(modelProperty, comboBoxChangeListener);
        return jComboBox;
    }

    public JComboBox createComboBox(DataModel dataModel, ModelProperty modelProperty, DataModel dataModel2, ModelProperty modelProperty2) {
        JComboBox jComboBox = new JComboBox(new ModelPropertyListModel(dataModel2, modelProperty2));
        jComboBox.setSelectedItem(dataModel.getProperty(modelProperty));
        jComboBox.addItemListener(new PropertySetterItemListener(dataModel, modelProperty));
        ComboBoxChangeListener comboBoxChangeListener = new ComboBoxChangeListener(jComboBox);
        this.makeStrongReference(jComboBox, comboBoxChangeListener);
        dataModel.addWeakPropertyChangeListener(modelProperty, comboBoxChangeListener);
        return jComboBox;
    }

    public JRadioButton createRadioButton(DataModel dataModel, ModelProperty modelProperty, Object object) {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setText(object.toString());
        this.bindButton(jRadioButton, dataModel, modelProperty, object);
        if (object.equals(dataModel.getProperty(modelProperty))) {
            jRadioButton.setSelected(true);
        }
        return jRadioButton;
    }

    public JComponent createRadioButtons(DataModel dataModel, ModelProperty modelProperty, List list) {
        Box box = new Box(1);
        this.buildRadioButtons(box, dataModel, modelProperty, list, null, null);
        this.addFiller(box);
        return box;
    }

    public JComponent createRadioButtons(DataModel dataModel, ModelProperty modelProperty, List list, Integer n2, Integer n3) {
        Box box = new Box(1);
        this.buildRadioButtons(box, dataModel, modelProperty, list, n2, n3);
        this.addFiller(box);
        return box;
    }

    public JSpinner createSpinner(DataModel dataModel, ModelProperty modelProperty, Integer n2, Integer n3) {
        return this.buildSpinner(dataModel, modelProperty, n2, n3);
    }

    public void bindTextField(JTextField jTextField, DataModel dataModel, ModelProperty modelProperty) {
        jTextField.addKeyListener(new PropertySetterKeyListener(dataModel, modelProperty));
        TextFieldChangeListener textFieldChangeListener = new TextFieldChangeListener(jTextField);
        this.makeStrongReference(jTextField, textFieldChangeListener);
        dataModel.addWeakPropertyChangeListener(modelProperty, textFieldChangeListener);
    }

    public JTextField createTextField(DataModel dataModel, ModelProperty modelProperty) {
        JTextField jTextField = new JTextField(dataModel.getProperty(modelProperty).toString());
        this.bindTextField(jTextField, dataModel, modelProperty);
        return jTextField;
    }

    public JTextField createConstrainedTextField(DataModel dataModel, ModelProperty modelProperty, String string, int n2) {
        ConstrainedTextField constrainedTextField = new ConstrainedTextField(dataModel.getProperty(modelProperty).toString(), string, n2);
        this.bindTextField(constrainedTextField, dataModel, modelProperty);
        return constrainedTextField;
    }

    public JTextField createIntegerTextField(DataModel dataModel, ModelProperty modelProperty) {
        return this.createConstrainedTextField(dataModel, modelProperty, INTEGER_TEXT_FIELD_REGEX, 10);
    }

    public JPopupMenu createPopupMenu(DataModel dataModel, ModelProperty modelProperty, List list) {
        return this.createPopupMenu(new JPopupMenu(), dataModel, modelProperty, list);
    }

    public JPopupMenu createPopupMenu(JPopupMenu jPopupMenu, DataModel dataModel, ModelProperty modelProperty, List list) {
        jPopupMenu.setName(modelProperty.getDescription());
        jPopupMenu.removeAll();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            JMenuItem jMenuItem = new JMenuItem(e2.toString());
            jMenuItem.addActionListener(new PropertySetterAction(dataModel, modelProperty, e2));
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public JList createList(DataModel dataModel, ModelProperty modelProperty, ModelProperty modelProperty2) {
        JList jList = new JList(new ModelPropertyListModel(dataModel, modelProperty2));
        jList.setSelectionMode(0);
        jList.addListSelectionListener(new PropertySetterListSelectionListener(dataModel, modelProperty));
        ListSelectionChangeListener listSelectionChangeListener = new ListSelectionChangeListener(jList);
        dataModel.addWeakPropertyChangeListener(modelProperty, listSelectionChangeListener);
        this.makeStrongReference(jList, listSelectionChangeListener);
        return jList;
    }

    public void bindButton(AbstractButton abstractButton, DataModel dataModel, ModelProperty modelProperty, Object object) {
        abstractButton.addActionListener(new PropertySetterActionListener(dataModel, modelProperty, object));
        if (abstractButton instanceof JToggleButton) {
            ButtonChangeListener buttonChangeListener = new ButtonChangeListener(abstractButton, object);
            dataModel.addWeakPropertyChangeListener(modelProperty, buttonChangeListener);
            this.makeStrongReference(abstractButton, buttonChangeListener);
            if (dataModel.getProperty(modelProperty) == object) {
                abstractButton.setSelected(true);
            }
        }
    }

    public void bindComponentEnabled(JComponent jComponent, DataModel dataModel, ModelProperty modelProperty) {
        this.bindComponentEnabled(new JComponent[]{jComponent}, dataModel, modelProperty);
    }

    public void bindComponentEnabled(JComponent[] jComponentArray, DataModel dataModel, ModelProperty modelProperty) {
        boolean bl2 = (Boolean)dataModel.getProperty(modelProperty);
        for (int i2 = 0; i2 < jComponentArray.length; ++i2) {
            ComponentEnablerChangeListener componentEnablerChangeListener = new ComponentEnablerChangeListener(jComponentArray[i2]);
            dataModel.addWeakPropertyChangeListener(modelProperty, componentEnablerChangeListener);
            this.makeStrongReference(jComponentArray[i2], componentEnablerChangeListener);
            jComponentArray[i2].setEnabled(bl2);
        }
    }

    public void makeStrongReference(JComponent jComponent, Object object) {
        jComponent.putClientProperty(new Integer(System.identityHashCode(object)), object);
    }

    private void addFiller(JComponent jComponent) {
        jComponent.add(Box.createHorizontalStrut(4));
    }

    private void buildRadioButtons(JComponent jComponent, DataModel dataModel, ModelProperty modelProperty, List list, Integer n2, Integer n3) {
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            JRadioButton jRadioButton = this.createRadioButton(dataModel, modelProperty, e2);
            jRadioButton.setAlignmentX(0.0f);
            jComponent.add(jRadioButton);
            buttonGroup.add(jRadioButton);
        }
        if (n2 == null || n3 == null) {
            return;
        }
        this.buildRadioSpinner(jComponent, dataModel, modelProperty, n2, n3, buttonGroup);
    }

    private void buildRadioSpinner(JComponent jComponent, DataModel dataModel, ModelProperty modelProperty, Integer n2, Integer n3, ButtonGroup buttonGroup) {
        JSpinner jSpinner = this.buildSpinner(dataModel, modelProperty, n2, n3);
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setAction(new SpinnerSetPropertyAction("", (ModelPropertySpinnerModel)jSpinner.getModel()));
        ButtonSelectorChangeListener buttonSelectorChangeListener = new ButtonSelectorChangeListener(jRadioButton);
        this.makeStrongReference(jSpinner, buttonSelectorChangeListener);
        jSpinner.addChangeListener(buttonSelectorChangeListener);
        jRadioButton.setSelected(((ModelPropertySpinnerModel)jSpinner.getModel()).sameValueAsDataModel());
        Box box = new Box(0);
        box.add(jRadioButton);
        box.add(jSpinner);
        box.setAlignmentX(0.0f);
        jComponent.add(box);
        buttonGroup.add(jRadioButton);
    }

    private JSpinner buildSpinner(DataModel dataModel, ModelProperty modelProperty, Integer n2, Integer n3) {
        ModelPropertySpinnerModel modelPropertySpinnerModel = new ModelPropertySpinnerModel(dataModel, modelProperty, n2.intValue(), n3.intValue());
        return new JSpinner(modelPropertySpinnerModel);
    }
}

