/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.DataModels;

import DataModels.DataModel;
import DataModels.ModelProperty;
import GuiUtilities.DataModels.ComponentType;
import GuiUtilities.DataModels.DataModelComponentFactory;
import com.intelerad.datamodels.validation.CompositeValidator;
import com.intelerad.datamodels.validation.Validator;
import com.intelerad.datamodels.validation.ValueInListValidator;
import com.intelerad.datamodels.validation.ValueInRangeValidator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class ValidatorComponentFactory {
    private final DataModelComponentFactory mFactory = new DataModelComponentFactory();

    public DataModelComponentFactory getComponentFactory() {
        return this.mFactory;
    }

    public JComponent createComponent(ComponentType componentType, Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        if (validator == null) {
            return new JLabel("Not used");
        }
        Object object = this.getUniqueValue(validator);
        if (object != null) {
            return new JLabel(object.toString());
        }
        if (ComponentType.ComboBox == componentType) {
            return this.mFactory.createComboBox(dataModel, modelProperty, validator.getValidValues());
        }
        if (ComponentType.RadioButtons == componentType) {
            return this.buildRadioButtons(validator, dataModel, modelProperty);
        }
        if (ComponentType.Spinner == componentType) {
            return this.buildSpinner(validator, dataModel, modelProperty);
        }
        if (ComponentType.TextField == componentType) {
            return this.buildTextField(validator, dataModel, modelProperty);
        }
        if (ComponentType.CheckBox == componentType) {
            return this.buildCheckBox(validator, dataModel, modelProperty);
        }
        throw new UnsupportedOperationException();
    }

    private JComponent buildCheckBox(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        List list = validator.getValidValues();
        if (list.size() != 2) {
            throw new IllegalArgumentException("Expected a validator with 2 value found " + list.size());
        }
        return this.mFactory.createCheckBox(dataModel, modelProperty, list.get(0), list.get(1));
    }

    public JComponent createRadioButtons(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        return this.createComponent(ComponentType.RadioButtons, validator, dataModel, modelProperty);
    }

    public JComponent createSpinner(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        return this.createComponent(ComponentType.Spinner, validator, dataModel, modelProperty);
    }

    public JComponent createTextField(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        return this.createComponent(ComponentType.TextField, validator, dataModel, modelProperty);
    }

    public JComponent createComboBox(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        return this.createComponent(ComponentType.ComboBox, validator, dataModel, modelProperty);
    }

    public void fillPopupMenu(Validator validator, JPopupMenu jPopupMenu, DataModel dataModel, ModelProperty modelProperty) {
        this.mFactory.createPopupMenu(jPopupMenu, dataModel, modelProperty, validator.getValidValues());
    }

    private JComponent buildRadioButtons(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        ValueInListValidator valueInListValidator = CompositeValidator.getValueInListValidator(validator);
        ValueInRangeValidator valueInRangeValidator = CompositeValidator.getValueInRangeValidator(validator);
        if (valueInRangeValidator != null && valueInListValidator != null) {
            return this.mFactory.createRadioButtons(dataModel, modelProperty, valueInListValidator.getValidValues(), valueInRangeValidator.getFirst(), valueInRangeValidator.getLast());
        }
        if (valueInListValidator != null) {
            return this.mFactory.createRadioButtons(dataModel, modelProperty, valueInListValidator.getValidValues());
        }
        if (valueInRangeValidator != null) {
            return this.mFactory.createSpinner(dataModel, modelProperty, valueInRangeValidator.getFirst(), valueInRangeValidator.getLast());
        }
        return null;
    }

    private JSpinner buildSpinner(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        ValueInRangeValidator valueInRangeValidator = CompositeValidator.getValueInRangeValidator(validator);
        if (valueInRangeValidator != null) {
            return this.mFactory.createSpinner(dataModel, modelProperty, valueInRangeValidator.getFirst(), valueInRangeValidator.getLast());
        }
        return null;
    }

    private JTextField buildTextField(Validator validator, DataModel dataModel, ModelProperty modelProperty) {
        return this.mFactory.createTextField(dataModel, modelProperty);
    }

    private Object getUniqueValue(Validator validator) {
        List list = validator.getValidValues();
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }
}

