/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Icon;

import java.awt.Image;
import javax.swing.ImageIcon;

public class ScaledImageIcon
extends ImageIcon {
    private ImageIcon mOriginalImageIcon;

    public ScaledImageIcon(Image image) {
        this(new ImageIcon(image));
    }

    public ScaledImageIcon(ImageIcon imageIcon) {
        this(imageIcon, imageIcon.getIconHeight());
    }

    public ScaledImageIcon(ImageIcon imageIcon, int n2) {
        super(imageIcon.getImage());
        this.initOriginalImageIcon(imageIcon);
        this.scaleHeight(n2);
    }

    public ScaledImageIcon(ImageIcon imageIcon, int n2, int n3) {
        super(imageIcon.getImage());
        this.initOriginalImageIcon(imageIcon);
        this.setSize(n2, n3);
    }

    private void initOriginalImageIcon(ImageIcon imageIcon) {
        this.mOriginalImageIcon = imageIcon instanceof ScaledImageIcon ? ((ScaledImageIcon)imageIcon).mOriginalImageIcon : imageIcon;
    }

    private void scaleHeight(int n2) {
        int n3 = this.mOriginalImageIcon.getIconWidth() * n2 / this.mOriginalImageIcon.getIconHeight();
        this.setSize(n3, n2);
    }

    private void setSize(int n2, int n3) {
        this.setImage(this.mOriginalImageIcon.getImage().getScaledInstance(n2, n3, 4));
    }
}

