/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.JCalendar.Calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private JButton[] days;
    private JButton selectedDay = null;
    private int day;
    private Color oldDayBackgroundColor;
    private Color selectedColor;
    private Color colorRed;
    private Color colorBlue;
    private String[] dayNames;
    private Calendar calendar;
    private Calendar today;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public JDayChooser() {
        this.days = new JButton[49];
        this.today = (Calendar)Calendar.getInstance(this.locale).clone();
        this.setLayout(new GridLayout(7, 7));
        for (int i2 = 0; i2 < 7; ++i2) {
            for (int i3 = 0; i3 < 7; ++i3) {
                int n2 = i3 + 7 * i2;
                if (i2 == 0) {
                    this.days[n2] = new JButton(){

                        public void addMouseListener(MouseListener mouseListener) {
                        }

                        public boolean isFocusable() {
                            return false;
                        }
                    };
                    this.days[n2].setBackground(new Color(180, 180, 200));
                } else {
                    this.days[n2] = new JButton("x");
                    this.days[n2].addActionListener(this);
                    this.days[n2].addKeyListener(this);
                    this.days[n2].addFocusListener(this);
                }
                this.days[n2].setMargin(new Insets(0, 0, 0, 0));
                this.days[n2].setFocusPainted(false);
                this.add(this.days[n2]);
            }
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.initialized = true;
    }

    protected void init() {
        this.colorRed = new Color(164, 0, 0);
        this.colorBlue = new Color(0, 0, 164);
        JButton jButton = new JButton();
        this.oldDayBackgroundColor = jButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        this.calendar = Calendar.getInstance(this.locale);
        int n2 = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int n3 = n2;
        for (int i2 = 0; i2 < 7; ++i2) {
            this.days[i2].setText(this.dayNames[n3]);
            if (n3 == 1) {
                this.days[i2].setForeground(this.colorRed);
            } else {
                this.days[i2].setForeground(this.colorBlue);
            }
            if (n3 < 7) {
                ++n3;
                continue;
            }
            n3 -= 6;
        }
        this.drawDays();
    }

    protected void drawDays() {
        int n2;
        Calendar calendar = (Calendar)this.calendar.clone();
        int n3 = calendar.getFirstDayOfWeek();
        calendar.set(5, 1);
        int n4 = calendar.get(7) - n3;
        if (n4 < 0) {
            n4 += 7;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.days[n2 + 7].setVisible(false);
            this.days[n2 + 7].setText("");
        }
        calendar.add(2, 1);
        Date date = calendar.getTime();
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        int n5 = 0;
        Color color = this.getForeground();
        while (date2.before(date)) {
            this.days[n2 + n5 + 7].setText(Integer.toString(n5 + 1));
            this.days[n2 + n5 + 7].setVisible(true);
            if (calendar.get(6) == this.today.get(6) && calendar.get(1) == this.today.get(1)) {
                this.days[n2 + n5 + 7].setForeground(this.colorRed);
            } else {
                this.days[n2 + n5 + 7].setForeground(color);
            }
            if (n5 + 1 == this.day) {
                this.days[n2 + n5 + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[n2 + n5 + 7];
            } else {
                this.days[n2 + n5 + 7].setBackground(this.oldDayBackgroundColor);
            }
            ++n5;
            calendar.add(5, 1);
            date2 = calendar.getTime();
        }
        for (int i2 = n5 + n2 + 7; i2 < 49; ++i2) {
            this.days[i2].setVisible(false);
            this.days[i2].setText("");
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.init();
        }
    }

    public void setDay(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n3 = calendar.get(5);
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = this.day;
        this.day = n2;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        for (int i2 = 7; i2 < 49; ++i2) {
            if (!this.days[i2].getText().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[i2];
            this.selectedDay.setBackground(this.selectedColor);
            break;
        }
        this.firePropertyChange("day", n4, this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int n2) {
        this.calendar.set(2, n2);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int n2) {
        this.calendar.set(1, n2);
        this.drawDays();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.drawDays();
    }

    public void setFont(Font font) {
        if (this.days != null) {
            for (int i2 = 0; i2 < 49; ++i2) {
                this.days[i2].setFont(font);
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.days != null) {
            for (int i2 = 7; i2 < 49; ++i2) {
                this.days[i2].setForeground(color);
            }
            this.drawDays();
        }
    }

    public String getName() {
        return "JDayChooser";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        int n2 = new Integer(string);
        this.setDay(n2);
    }

    public void focusGained(FocusEvent focusEvent) {
        JButton jButton = (JButton)focusEvent.getSource();
        String string = jButton.getText();
        if (string != null && !string.equals("")) {
            this.actionPerformed(new ActionEvent(focusEvent.getSource(), 0, null));
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2;
        int n3 = keyEvent.getKeyCode() == 38 ? -7 : (keyEvent.getKeyCode() == 40 ? 7 : (keyEvent.getKeyCode() == 37 ? -1 : (n2 = keyEvent.getKeyCode() == 39 ? 1 : 0)));
        if (n2 != 0) {
            for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
                if (this.getComponent(i2) != this.selectedDay) continue;
                if ((i2 += n2) <= 7 || i2 >= this.days.length || !this.days[i2].isVisible()) break;
                this.days[i2].requestFocus();
                break;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        for (int n2 = 0; n2 < this.days.length; n2 = (int)((short)(n2 + 1))) {
            if (this.days[n2] == null) continue;
            this.days[n2].setEnabled(bl2);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JDayChooser");
        jFrame.getContentPane().add(new JDayChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

