/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.JCalendar.Calendar;

import GuiUtilities.JCalendar.Calendar.JDayChooser;
import GuiUtilities.JCalendar.Calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JMonthChooser
extends JPanel
implements ItemListener,
AdjustmentListener {
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    private Locale locale;
    private int month;
    private int oldScrollBarValue = 0;
    private JDayChooser dayChooser = null;
    private JYearChooser yearChooser = null;
    private JComboBox comboBox;
    private JScrollBar scrollBar;
    private boolean initialized = false;
    private boolean localInitialize = false;

    public JMonthChooser() {
        this(0);
    }

    public JMonthChooser(int n2) {
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(this);
        this.dayChooser = null;
        this.locale = Locale.getDefault();
        this.initNames();
        this.add((Component)this.comboBox, "Center");
        if (n2 != 2) {
            this.scrollBar = new JScrollBar(1, 0, 0, -10000, 10000);
            this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.getPreferredSize().height));
            this.scrollBar.setVisibleAmount(0);
            this.scrollBar.addAdjustmentListener(this);
            if (n2 == 0) {
                this.add((Component)this.scrollBar, "East");
            } else {
                this.add((Component)this.scrollBar, "West");
            }
        }
        this.initialized = true;
        this.setMonth(Calendar.getInstance().get(2));
    }

    public void initNames() {
        this.localInitialize = true;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] stringArray = dateFormatSymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAllItems();
        }
        for (int i2 = 0; i2 < 12; ++i2) {
            this.comboBox.addItem(stringArray[i2]);
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n2 = this.comboBox.getSelectedIndex();
        if (n2 >= 0) {
            this.setMonth(n2, false);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        boolean bl2 = true;
        int n2 = adjustmentEvent.getValue();
        if (n2 > this.oldScrollBarValue) {
            bl2 = false;
        }
        this.oldScrollBarValue = n2;
        int n3 = this.getMonth();
        if (bl2) {
            if (++n3 == 12) {
                n3 = 0;
                if (this.yearChooser != null) {
                    int n4 = this.yearChooser.getYear();
                    this.yearChooser.setYear(++n4);
                }
            }
        } else if (--n3 == -1) {
            n3 = 11;
            if (this.yearChooser != null) {
                int n5 = this.yearChooser.getYear();
                this.yearChooser.setYear(--n5);
            }
        }
        this.setMonth(n3);
    }

    private void setMonth(int n2, boolean bl2) {
        if (!this.initialized || this.localInitialize) {
            return;
        }
        int n3 = this.month;
        this.month = n2;
        if (bl2) {
            this.comboBox.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", n3, this.month);
    }

    public void setMonth(int n2) {
        this.setMonth(n2, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser jDayChooser) {
        this.dayChooser = jDayChooser;
    }

    public void setYearChooser(JYearChooser jYearChooser) {
        this.yearChooser = jYearChooser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.initNames();
        }
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.comboBox.setEnabled(bl2);
        if (this.scrollBar != null) {
            this.scrollBar.setEnabled(bl2);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("MonthChooser");
        jFrame.getContentPane().add(new JMonthChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

