/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Layouts;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class GridBagBuilder {
    private final GridBagConstraints mContraints;

    public GridBagBuilder() {
        this.mContraints = new GridBagConstraints();
    }

    public GridBagBuilder(GridBagBuilder gridBagBuilder) {
        this.mContraints = this.copy(gridBagBuilder.mContraints);
    }

    private GridBagBuilder(GridBagConstraints gridBagConstraints) {
        this.mContraints = gridBagConstraints;
    }

    private GridBagConstraints copy(GridBagConstraints gridBagConstraints) {
        return (GridBagConstraints)this.mContraints.clone();
    }

    public GridBagBuilder setLocation(int n2, int n3) {
        GridBagConstraints gridBagConstraints = this.copy(this.mContraints);
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        return new GridBagBuilder(gridBagConstraints);
    }

    public GridBagBuilder setFill(int n2, double d2, double d3) {
        GridBagConstraints gridBagConstraints = this.copy(this.mContraints);
        gridBagConstraints.fill = n2;
        gridBagConstraints.weightx = d2;
        gridBagConstraints.weighty = d3;
        return new GridBagBuilder(gridBagConstraints);
    }

    public GridBagBuilder setIPad(int n2, int n3) {
        GridBagConstraints gridBagConstraints = this.copy(this.mContraints);
        gridBagConstraints.ipadx = n2;
        gridBagConstraints.ipady = n3;
        return new GridBagBuilder(gridBagConstraints);
    }

    public GridBagBuilder setSize(int n2, int n3) {
        GridBagConstraints gridBagConstraints = this.copy(this.mContraints);
        gridBagConstraints.gridheight = n3;
        gridBagConstraints.gridwidth = n2;
        return new GridBagBuilder(gridBagConstraints);
    }

    public GridBagBuilder setInsets(int n2, int n3, int n4, int n5) {
        GridBagConstraints gridBagConstraints = this.copy(this.mContraints);
        gridBagConstraints.insets = new Insets(n2, n3, n4, n5);
        return new GridBagBuilder(gridBagConstraints);
    }

    public GridBagBuilder setAnchor(int n2) {
        GridBagConstraints gridBagConstraints = this.copy(this.mContraints);
        gridBagConstraints.anchor = n2;
        return new GridBagBuilder(gridBagConstraints);
    }

    public GridBagConstraints getConstraints() {
        return this.copy(this.mContraints);
    }
}

