/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Layouts;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class GridBagPanelBuilder {
    public static final String LABEL = "label";
    public static final String FIELD = "field";
    public static final String FILLER = "filler";
    private final JPanel mPanel;
    private final LayoutStrategy mLayoutStrategy;
    private final Map mPrototypes = new HashMap();

    public GridBagPanelBuilder(JPanel jPanel, LayoutStrategy layoutStrategy) {
        this.mLayoutStrategy = layoutStrategy;
        this.mPanel = jPanel;
        this.mPanel.setLayout(new GridBagLayout());
    }

    public JPanel getPanel() {
        return this.mPanel;
    }

    public void setTitleBorder(String string) {
        this.mPanel.setBorder(new TitledBorder(string));
    }

    public void addFiller() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(0, 0));
        this.add(FILLER, jPanel);
    }

    public void addPrototype(Object object, GridBagConstraints gridBagConstraints) {
        this.mPrototypes.put(object, gridBagConstraints.clone());
    }

    public void add(Object object, Component component) {
        this.mPanel.add(component, this.mLayoutStrategy.layout(object, this.getPrototype(object), component));
    }

    private GridBagConstraints getPrototype(Object object) {
        return (GridBagConstraints)this.mPrototypes.get(object);
    }

    private static GridBagConstraints clone(GridBagConstraints gridBagConstraints) {
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    public static class OneRowLayoutStrategy
    implements LayoutStrategy {
        private int mColumnIndex = 0;

        public GridBagConstraints layout(Object object, GridBagConstraints gridBagConstraints, Component component) {
            GridBagConstraints gridBagConstraints2 = GridBagPanelBuilder.clone(gridBagConstraints);
            gridBagConstraints2.gridx = this.mColumnIndex++;
            return gridBagConstraints2;
        }
    }

    public static class NextRowLayoutStrategy
    implements LayoutStrategy {
        private int mMaxGridY = 0;

        public GridBagConstraints layout(Object object, GridBagConstraints gridBagConstraints, Component component) {
            ++gridBagConstraints.gridy;
            if (gridBagConstraints.gridy > this.mMaxGridY) {
                this.mMaxGridY = gridBagConstraints.gridy;
            }
            GridBagConstraints gridBagConstraints2 = GridBagPanelBuilder.clone(gridBagConstraints);
            if (object == GridBagPanelBuilder.FILLER) {
                gridBagConstraints2.gridy = ++this.mMaxGridY;
            }
            return gridBagConstraints2;
        }
    }

    public static class DefaultLayoutStrategy
    implements LayoutStrategy {
        public GridBagConstraints layout(Object object, GridBagConstraints gridBagConstraints, Component component) {
            return gridBagConstraints;
        }
    }

    public static interface LayoutStrategy {
        public GridBagConstraints layout(Object var1, GridBagConstraints var2, Component var3);
    }
}

