/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Table;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ArrayUtils;

public abstract class TableMouseListener
extends MouseAdapter {
    private JPopupMenu mMenu;

    public TableMouseListener(JPopupMenu jPopupMenu) {
        this.mMenu = jPopupMenu;
    }

    private boolean isMenuEnabled(JTable jTable) {
        return this.mMenu != null && jTable.getSelectedRowCount() > 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getComponent();
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n2 = jTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            int[] nArray = jTable.getSelectedRows();
            if (!ArrayUtils.contains((int[])nArray, (int)n2) && n2 >= 0) {
                jTable.setRowSelectionInterval(n2, n2);
            }
            if (this.isMenuEnabled(jTable)) {
                this.mMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2) {
            this.mouseDoubleClicked();
        }
    }

    protected abstract void mouseDoubleClicked();
}

