/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel {
    protected TableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    public static final int DEFAULT_SORT = 1;
    public static final int HIGHEST_SORT_PRIORITY = 0;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map columnComparators = new HashMap();
    private List sortingColumnDirectives = new ArrayList();

    public TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableSorter(TableModel tableModel, JTableHeader jTableHeader) {
        this();
        this.setTableHeader(jTableHeader);
        this.setTableModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumnDirectives.size() != 0;
    }

    private Directive getDirective(int n2) {
        for (int i2 = 0; i2 < this.sortingColumnDirectives.size(); ++i2) {
            Directive directive = (Directive)this.sortingColumnDirectives.get(i2);
            if (directive.column != n2) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int n2) {
        return this.getDirective(n2).direction;
    }

    private boolean isPrimarySort(int n2) {
        if (this.sortingColumnDirectives.size() == 0) {
            return false;
        }
        return ((Directive)this.sortingColumnDirectives.get(0)).column == n2;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int n2, int n3) {
        Directive directive = this.getDirective(n2);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumnDirectives.remove(directive);
        }
        if (n3 != 0) {
            this.sortingColumnDirectives.add(0, new Directive(n2, n3));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int n2, int n3) {
        Directive directive = this.getDirective(n2);
        if (this.isPrimarySort(n2)) {
            return new Arrow(directive.direction == -1, n3, 0);
        }
        return null;
    }

    private void cancelSorting() {
        this.sortingColumnDirectives.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class clazz, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    protected Comparator getComparator(int n2) {
        Class<?> clazz = this.tableModel.getColumnClass(n2);
        Comparator comparator = (Comparator)this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMPARATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int n2 = this.tableModel.getRowCount();
            this.viewToModel = new Row[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.viewToModel[i2] = new Row(i2);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int n2) {
        return this.getViewToModel()[n2].modelIndex;
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n2 = this.getViewToModel().length;
            this.modelToView = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.modelToView[this.modelIndex((int)i2)] = i2;
            }
        }
        return this.modelToView;
    }

    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int n2) {
        return this.tableModel.getColumnName(n2);
    }

    public Class getColumnClass(int n2) {
        return this.tableModel.getColumnClass(n2);
    }

    public boolean isCellEditable(int n2, int n3) {
        return this.tableModel.isCellEditable(this.modelIndex(n2), n3);
    }

    public Object getValueAt(int n2, int n3) {
        return this.tableModel.getValueAt(this.modelIndex(n2), n3);
    }

    public void setValueAt(Object object, int n2, int n3) {
        this.tableModel.setValueAt(object, this.modelIndex(n2), n3);
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int n2, int n3) {
            this.column = n2;
            this.direction = n3;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n4 = jTable.convertColumnIndexToModel(n3);
                jLabel.setIcon(TableSorter.this.getHeaderRendererIcon(n4, jLabel.getFont().getSize()));
            }
            return component;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean bl2, int n2, int n3) {
            this.descending = bl2;
            this.size = n2;
            this.priority = n3;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = component == null ? Color.GRAY : component.getBackground();
            int n4 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n5 = this.descending ? n4 : -n4;
            n3 = n3 + 5 * this.size / 6 + (this.descending ? -n5 : 0);
            int n6 = this.descending ? 1 : -1;
            graphics.translate(n2, n3);
            graphics.setColor(color.darker());
            graphics.drawLine(n4 / 2, n5, 0, 0);
            graphics.drawLine(n4 / 2, n5 + n6, 0, n6);
            graphics.setColor(color.brighter());
            graphics.drawLine(n4 / 2, n5, n4, 0);
            graphics.drawLine(n4 / 2, n5 + n6, n4, n6);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n4, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n3 = tableColumnModel.getColumn(n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n3 == -1) {
                return;
            }
            int n4 = TableSorter.this.getSortingStatus(n3);
            if (TableSorter.this.isPrimarySort(n3)) {
                TableSorter.this.setSortingStatus(n3, n4 == 1 ? -1 : 1);
            } else {
                TableSorter.this.setSortingStatus(n3, n4 == 0 ? 1 : n4);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.clearSortingState();
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                TableSorter.this.cancelSorting();
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n2 = tableModelEvent.getColumn();
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n2 != -1 && TableSorter.this.getSortingStatus(n2) == 0 && TableSorter.this.modelToView != null) {
                int n3 = TableSorter.this.getModelToView()[tableModelEvent.getFirstRow()];
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this, n3, n3, n2, tableModelEvent.getType()));
                return;
            }
            TableSorter.this.clearSortingState();
            TableSorter.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n2) {
            this.modelIndex = n2;
        }

        public int compareTo(Object object) {
            int n2 = this.modelIndex;
            int n3 = ((Row)object).modelIndex;
            Iterator iterator = TableSorter.this.sortingColumnDirectives.iterator();
            while (iterator.hasNext()) {
                Directive directive = (Directive)iterator.next();
                int n4 = directive.column;
                Object object2 = TableSorter.this.tableModel.getValueAt(n2, n4);
                Object object3 = TableSorter.this.tableModel.getValueAt(n3, n4);
                int n5 = 0;
                n5 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : TableSorter.this.getComparator(n4).compare(object2, object3)));
                if (n5 == 0) continue;
                return directive.direction == -1 ? -n5 : n5;
            }
            return 0;
        }
    }
}

