/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import RuntimeTool.DebugManager;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class AlwaysOnTop {
    private static final AlwaysOnTopService mAlwaysOnTopService;
    private static Map mFrames;

    private static AlwaysOnTopService createAlwaysOnTopService() {
        if (AlwaysOnTop.hasJavaSetAlwaysOnTopMethod()) {
            return AlwaysOnTop.createJavaAlwaysOnTopService();
        }
        return AlwaysOnTop.createNativeAlwaysOnTopService();
    }

    private static AlwaysOnTopService createJavaAlwaysOnTopService() {
        return new AlwaysOnTopService(){

            public boolean isAvailable() {
                try {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Method method = toolkit.getClass().getMethod("isAlwaysOnTopSupported", null);
                    Object object = method.invoke((Object)toolkit, null);
                    return object instanceof Boolean ? (Boolean)object : false;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public void setAlwaysOnTop(Frame frame, boolean bl2) {
                Method method = AlwaysOnTop.getJavaSetAlwaysOnTopMethod(frame);
                if (method == null) {
                    return;
                }
                try {
                    method.invoke((Object)frame, bl2);
                }
                catch (Exception exception) {
                    DebugManager.getDefault().printException("Failed to setAlwaysOnTop", exception);
                }
            }
        };
    }

    private static AlwaysOnTopService createNativeAlwaysOnTopService() {
        try {
            System.loadLibrary("AlwaysOnTop");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            DebugManager.getDefault().printWarning("AlwaysOnTop library not loaded");
            return AlwaysOnTop.createNullAlwaysOnTopService();
        }
        return new AlwaysOnTopService(){

            public boolean isAvailable() {
                return AlwaysOnTop.isSupportedOs();
            }

            public void setAlwaysOnTop(Frame frame, boolean bl2) {
                AlwaysOnTop.setAlwaysOnTopByTitle(frame.getTitle(), bl2);
            }
        };
    }

    private static AlwaysOnTopService createNullAlwaysOnTopService() {
        return new AlwaysOnTopService(){

            public boolean isAvailable() {
                return false;
            }

            public void setAlwaysOnTop(Frame frame, boolean bl2) {
            }
        };
    }

    public static void setAlwaysOnTop(Frame frame, boolean bl2) {
        if (AlwaysOnTop.isAvailable() && frame != null) {
            AlwaysOnTop.debug("In AlwaysOnTop.setAlwaysOnTop(); frame = " + frame + "; onTop = " + bl2);
            mAlwaysOnTopService.setAlwaysOnTop(frame, bl2);
            if (bl2) {
                AlwaysOnTop.debug("Adding frame to set of always-on-top frames");
                mFrames.put(frame, null);
            } else {
                AlwaysOnTop.debug("Removing frame from set of always-on-top frames");
                mFrames.remove(frame);
            }
            AlwaysOnTop.debug("Always-on-top frames: " + mFrames.keySet());
        }
    }

    public static Frame getAlwaysOnTopFrame() {
        if (!AlwaysOnTop.isAvailable()) {
            return null;
        }
        AlwaysOnTop.debug("In AlwaysOnTop.getAlwaysOnTopFrame()");
        Iterator iterator = mFrames.keySet().iterator();
        while (iterator.hasNext()) {
            Frame frame = (Frame)iterator.next();
            AlwaysOnTop.debug("Possible candidate frame " + frame + "; isShowing(): " + frame.isShowing());
            if (frame == null || !frame.isShowing()) continue;
            AlwaysOnTop.debug("Returning valid always-on-top frame: " + frame);
            return frame;
        }
        AlwaysOnTop.debug("Didn't find a valid always-on-top frame");
        return null;
    }

    public static void iconizeAlwaysOnTopFrames() {
        if (!AlwaysOnTop.isAvailable()) {
            return;
        }
        AlwaysOnTop.debug("In AlwaysOnTop.iconizeAlwaysOnTopFrames()");
        Iterator iterator = mFrames.keySet().iterator();
        while (iterator.hasNext()) {
            Frame frame = (Frame)iterator.next();
            AlwaysOnTop.debug("Possible candidate frame " + frame + "; isShowing(): " + frame.isShowing());
            if (frame == null || !frame.isShowing()) continue;
            frame.setState(1);
        }
        AlwaysOnTop.debug("Didn't find a valid always-on-top frame");
    }

    public static boolean isAvailable() {
        return mAlwaysOnTopService.isAvailable();
    }

    private static boolean isSupportedOs() {
        String string = System.getProperty("os.name");
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        return string2.startsWith("windows") && !string2.startsWith("windows 95") && !string2.startsWith("windows 98") && !string2.startsWith("windows nt");
    }

    private static native void setAlwaysOnTopByTitle(String var0, boolean var1);

    public static Frame getParentForDialog(Frame frame, boolean bl2) {
        return (Frame)AlwaysOnTop.findParent(frame, bl2);
    }

    public static Window getParentForDialog(Dialog dialog, boolean bl2) {
        return AlwaysOnTop.findParent(dialog, bl2);
    }

    private static Window findParent(Window window, boolean bl2) {
        AlwaysOnTop.debug("In AlwaysOnTop.getParentForDialog()");
        Frame frame = AlwaysOnTop.getAlwaysOnTopFrame();
        if (!bl2 || frame == null) {
            AlwaysOnTop.debug("modal = " + bl2 + "; alwaysOnTopFrame = " + frame);
            AlwaysOnTop.debug("getParentForDialog() returning: " + window);
            return window;
        }
        AlwaysOnTop.debug("modal = " + bl2 + "; alwaysOnTopFrame = " + frame);
        AlwaysOnTop.debug("getParentForDialog() returning: " + frame);
        return frame;
    }

    private static boolean debug(String string) {
        return DebugManager.getDefault().printDebug("AlwaysOnTop", string);
    }

    private static boolean hasJavaSetAlwaysOnTopMethod() {
        return AlwaysOnTop.getJavaSetAlwaysOnTopMethod(null) != null;
    }

    private static Method getJavaSetAlwaysOnTopMethod(Window window) {
        Class clazz = window == null ? Window.class : window.getClass();
        Class clazz2 = clazz;
        try {
            return clazz2.getMethod("setAlwaysOnTop", Boolean.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        mFrames = Collections.synchronizedMap(new WeakHashMap());
        mAlwaysOnTopService = AlwaysOnTop.createAlwaysOnTopService();
    }

    public static interface AlwaysOnTopService {
        public void setAlwaysOnTop(Frame var1, boolean var2);

        public boolean isAvailable();
    }
}

