/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.AlwaysOnTop;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;

public abstract class EnhancedDialog
extends JDialog {
    protected KeyHandler keyHandler;

    public EnhancedDialog(Frame frame, String string, boolean bl2) {
        super(AlwaysOnTop.getParentForDialog(frame, bl2), string, bl2);
        this.init();
    }

    public EnhancedDialog(Dialog dialog, String string, boolean bl2) {
        super(dialog, string, bl2);
        this.init();
    }

    private void init() {
        this.getLayeredPane().addContainerListener(new ContainerHandler());
        this.getContentPane().addContainerListener(new ContainerHandler());
        this.keyHandler = new KeyHandler();
        this.addKeyListener(this.keyHandler);
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
    }

    public abstract void ok();

    public abstract void cancel();

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            EnhancedDialog.this.cancel();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() instanceof JTextField && ((JTextField)keyEvent.getSource()).getActionListeners().length > 0) {
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                for (Component component = EnhancedDialog.this.getFocusOwner(); component != null; component = component.getParent()) {
                    Object object;
                    if (!(component instanceof JComboBox)) continue;
                    JComboBox jComboBox = (JComboBox)component;
                    if (!jComboBox.isEditable() || (object = jComboBox.getEditor().getItem()) == null) break;
                    jComboBox.setSelectedItem(object);
                    break;
                }
                EnhancedDialog.this.ok();
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 27) {
                EnhancedDialog.this.cancel();
                keyEvent.consume();
            }
        }
    }

    class ContainerHandler
    extends ContainerAdapter {
        ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            this.componentAdded(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            this.componentRemoved(containerEvent.getChild());
        }

        private void componentAdded(Component component) {
            component.addKeyListener(EnhancedDialog.this.keyHandler);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.addContainerListener(this);
                Component[] componentArray = container.getComponents();
                for (int i2 = 0; i2 < componentArray.length; ++i2) {
                    this.componentAdded(componentArray[i2]);
                }
            }
        }

        private void componentRemoved(Component component) {
            component.removeKeyListener(EnhancedDialog.this.keyHandler);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.removeContainerListener(this);
                Component[] componentArray = container.getComponents();
                for (int i2 = 0; i2 < componentArray.length; ++i2) {
                    this.componentRemoved(componentArray[i2]);
                }
            }
        }
    }
}

