/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Icon.ScaledImageIcon;
import GuiUtilities.Util.ScreenConfiguration;
import StringUtilities.StringSplit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GuiUtilities {
    private static GuiUtilities mGuiUtils = new GuiUtilities();
    private static ScreenConfiguration mScreenConfiguration = new ScreenConfiguration();

    public static void setNumberOfMonitors(int n2) {
        mScreenConfiguration = new ScreenConfiguration(n2);
    }

    public static int getNumberOfMonitors() {
        return mScreenConfiguration.getScreenCount();
    }

    public static List getMonitorLayout() {
        return mScreenConfiguration.getScreenBounds();
    }

    public static int getNumberOfDevices() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        return graphicsDeviceArray.length;
    }

    public static GraphicsConfiguration getBestGraphicsConfiguration() {
        return mScreenConfiguration.getBestGraphicsConfiguration();
    }

    public static void centerWindow(Component component) {
        GuiUtilities.centerWindow(mScreenConfiguration.getScreenBounds(0), component);
    }

    public static void centerWindow(Rectangle rectangle, Component component) {
        component.setLocation(mScreenConfiguration.getCentreOrigin(rectangle, component.getSize()));
    }

    public static void centerWindowOnParent(Component component, Component component2) {
        GuiUtilities.centerWindow(component.getBounds(), component2);
    }

    public static ScreenConfiguration getScreenConfiguration() {
        return mScreenConfiguration;
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Dimension getMaximumDimensionAcrossScreens() {
        return mScreenConfiguration.getMaximumDimension();
    }

    public static void setRelativeSize(Component component, int n2) {
        double d2 = (double)n2 / 100.0;
        if (n2 <= 0 || n2 > 100) {
            throw new IllegalArgumentException();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize((int)(dimension.getWidth() * d2), (int)(dimension.getHeight() * d2));
    }

    public static String getToolTip(String string, String string2) {
        String string3 = GuiUtilities.getStringWithBr(string2, 10);
        String string4 = "<html><body><font face =\"Ariel\"><strong><b><font color = BLACK>&nbsp;&nbsp;" + string + " : " + "</font><b></strong>" + "<tt><font color = DARKGRAY>" + " " + string3 + "</tt></font></font>" + "</a></body></html>";
        return string4;
    }

    public static String getStringWithBr(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        List list = StringSplit.split(string, " ");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            stringBuffer.append(list.get(i2));
            if (i2 >= list.size() - 1) continue;
            if ((i2 + 1) % n2 == 0) {
                stringBuffer.append("<br>");
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String getHtmlLabel(String string, String string2) {
        String string3 = mGuiUtils.getClass().getResource(string2).toString();
        return "<HTML><TABLE CELLPADDING=0><TR><TD><IMG SRC=\"" + string3 + "\">" + "</TD></TD WIDTH=5\"></TD>&nbsp;" + string + "</TD></TR></TABLE></HTML>";
    }

    public static String getHtmlLabel(String string, String string2, boolean bl2) {
        String string3 = mGuiUtils.getClass().getResource(string2).toString();
        if (bl2) {
            return GuiUtilities.getHtmlLabel(string, string2);
        }
        return "<HTML><TABLE CELLPADDING=0><TR><TD>" + string + "</TD></TD WIDTH=5\">" + "</TD>&nbsp;" + "<IMG SRC=\"" + string3 + "\">" + "</TD></TR>" + "</TABLE></HTML>";
    }

    public static void setAntialiasing(Graphics2D graphics2D, boolean bl2) {
        if (bl2) {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public static boolean isMaximized(Frame frame) {
        int n2 = frame.getExtendedState();
        return (n2 & 6) != 0;
    }

    public static void iconify(Frame frame) {
        int n2 = frame.getExtendedState();
        frame.setExtendedState(n2 |= 1);
    }

    public static void deiconify(Frame frame) {
        int n2 = frame.getExtendedState();
        frame.setExtendedState(n2 &= 0xFFFFFFFE);
    }

    public static void unmaximize(Frame frame) {
        int n2 = frame.getExtendedState();
        frame.setExtendedState(n2 &= 0xFFFFFFF9);
    }

    public static void maximize(Frame frame) {
        int n2 = frame.getExtendedState();
        frame.setExtendedState(n2 |= 6);
    }

    public static Border getTitledBorder(String string, Color color, Color color2, int n2) {
        return GuiUtilities.getTitledBorder(string, new EtchedBorder(color, color2), n2);
    }

    public static Border getTitledBorder(String string, int n2) {
        return GuiUtilities.getTitledBorder(string, new EtchedBorder(), n2);
    }

    public static Border getTitledBorder(String string, Border border, int n2) {
        return GuiUtilities.getTitledBorder(string, border, n2, Color.BLUE);
    }

    public static Border getTitledBorder(String string, Border border, int n2, Color color) {
        TitledBorder titledBorder = new TitledBorder(border, " " + string + " ");
        titledBorder.setTitleColor(color);
        EmptyBorder emptyBorder = new EmptyBorder(n2, n2, n2, n2);
        return new CompoundBorder(emptyBorder, titledBorder);
    }

    public static Timer setTemporaryBorder(JComponent jComponent, Timer timer, Border border, int n2, final Runnable runnable) {
        jComponent.setBorder(border);
        if (timer != null) {
            timer.stop();
        }
        Timer timer2 = new Timer(n2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        });
        timer2.setRepeats(false);
        timer2.start();
        return timer2;
    }

    public static boolean validateDateRange(Date date, Date date2, Component component) {
        if (date != null && date2 != null && !date.after(date2)) {
            return true;
        }
        if (component != null) {
            MultiMonitorOptionDialog.showConfirmDialog(component, "Invalid Date Range", "Invalid Date Range", -1, 0);
        }
        return false;
    }

    public static void resizeButtonIcon(AbstractButton abstractButton, int n2) {
        Icon icon = abstractButton.getIcon();
        if (icon.getIconHeight() == n2) {
            return;
        }
        if (icon instanceof ImageIcon) {
            abstractButton.setIcon(new ScaledImageIcon((ImageIcon)icon, n2));
        }
    }

    public static Component getAncestorOfClass(Component component, Class clazz) {
        Component component2 = component;
        while (component2 != null) {
            if (clazz.isInstance(component2)) {
                return component2;
            }
            if (component2 instanceof JPopupMenu) {
                component2 = ((JPopupMenu)component2).getInvoker();
                continue;
            }
            if (component2 instanceof JDialog) {
                component2 = ((JDialog)component2).getOwner();
                continue;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    public static void copyToClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }
}

