/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Util.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class MultiMonitorUtilities
extends JFrame
implements ActionListener {
    private JTextArea mInfoArea;
    private JComboBox mNumberOfMonitors;
    private JButton mIconify;
    private JButton mMinimize;
    private JButton mMaximize;
    private JButton mCenterThis;
    private JButton mCenterOnThis;
    private JButton mGetInfo;
    private JButton mClear;
    private JButton mClose;
    private final SimpleDateFormat mDateTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final Integer[] NUMBERS = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)};

    public MultiMonitorUtilities() {
        super("Multi-Monitor Utilities");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(jPanel);
        this.createSelectionPane(jPanel);
        this.createInfoPane(jPanel);
        this.createControlPane(jPanel);
    }

    private void createSelectionPane(JPanel jPanel) {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(5, 5, 5, 5));
        box.add(Box.createGlue());
        this.mNumberOfMonitors = new JComboBox<Integer>(NUMBERS);
        JLabel jLabel = new JLabel("Number of Monitor(s) : ");
        box.add(jLabel);
        box.add(this.mNumberOfMonitors);
        box.add(Box.createGlue());
        jPanel.add("North", box);
    }

    private void createInfoPane(JPanel jPanel) {
        this.mInfoArea = new JTextArea();
        this.mInfoArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.mInfoArea, 20, 30);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = Math.min(dimension.width, 500);
        dimension.height = Math.min(dimension.height, 300);
        jScrollPane.setPreferredSize(dimension);
        jPanel.add("Center", jScrollPane);
    }

    private void createControlPane(JPanel jPanel) {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(5, 5, 5, 5));
        box.add(Box.createGlue());
        this.mIconify = new JButton("Iconify");
        this.mMaximize = new JButton("Maximize");
        this.mMinimize = new JButton("UnMaximize");
        this.mCenterThis = new JButton("CenterThis");
        this.mCenterOnThis = new JButton("CenterOnThis");
        this.mGetInfo = new JButton("GetInfo");
        this.mClear = new JButton("Clear");
        this.mClose = new JButton("Close");
        this.mIconify.addActionListener(this);
        this.mMinimize.addActionListener(this);
        this.mMaximize.addActionListener(this);
        this.mCenterThis.addActionListener(this);
        this.mCenterOnThis.addActionListener(this);
        this.mGetInfo.addActionListener(this);
        this.mClear.addActionListener(this);
        this.mClose.addActionListener(this);
        box.add(this.mIconify);
        box.add(Box.createGlue());
        box.add(this.mMaximize);
        box.add(Box.createGlue());
        box.add(this.mMinimize);
        box.add(Box.createGlue());
        box.add(this.mCenterThis);
        box.add(Box.createGlue());
        box.add(this.mCenterOnThis);
        box.add(Box.createGlue());
        box.add(this.mGetInfo);
        box.add(Box.createGlue());
        box.add(this.mClear);
        box.add(Box.createGlue());
        box.add(this.mClose);
        box.add(Box.createGlue());
        this.getRootPane().setDefaultButton(this.mClose);
        jPanel.add("South", box);
    }

    private void printInfo(String string) {
        this.mInfoArea.append(" [" + this.mDateTimeFormat.format(new Date()) + "] -> " + string + "\n");
        this.mInfoArea.setCaretPosition(this.mInfoArea.getDocument().getLength());
        System.out.println(string);
    }

    public void getInfo() {
        this.printInfo("============ GetInfo =========================================");
        this.printInfo("Frame location = " + this.getLocation());
        this.printInfo("Frame size = " + this.getSize());
        this.printInfo("Maximized = " + this.isMaximized());
        this.printInfo("Toolkit screen size = " + Toolkit.getDefaultToolkit().getScreenSize());
        this.printInfo("Toolkit screen resolution = " + Toolkit.getDefaultToolkit().getScreenResolution());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        this.printInfo("Found " + graphicsDeviceArray.length + " display device(s)");
        this.printInfo("     Center point = " + graphicsEnvironment.getCenterPoint());
        this.printInfo("     Max  window bounds = " + graphicsEnvironment.getMaximumWindowBounds());
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i2];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            this.printInfo("     Display " + i2 + " display changes supported = " + graphicsDevice.isDisplayChangeSupported());
            this.printInfo("     Display " + i2 + " full screen mode supported = " + graphicsDevice.isFullScreenSupported());
            this.printInfo("     Display " + i2 + " available accelerate memory = " + graphicsDevice.getAvailableAcceleratedMemory());
            try {
                DisplayMode displayMode = graphicsDevice.getDisplayMode();
                this.printInfo("     Display Mode " + i2 + " screen size = " + displayMode.getWidth() + " x " + displayMode.getHeight());
                this.printInfo("     Display Mode " + i2 + " refresh rate = " + displayMode.getRefreshRate());
                this.printInfo("     Display Mode " + i2 + " bit depth = " + displayMode.getBitDepth());
                this.printInfo("     Display Mode " + i2 + " number of colours = " + (int)Math.pow(2.0, displayMode.getBitDepth()));
            }
            catch (Throwable throwable) {
                this.printInfo("     Error getting DisplayMode for GraphicsDevice " + i2);
            }
            for (int i3 = 0; i3 < graphicsConfigurationArray.length; ++i3) {
                this.printInfo("     ( Screen " + i3 + ", GC " + i3 + " ) vitual screen bounds = " + graphicsConfigurationArray[i3].getBounds());
            }
        }
        this.printInfo("==========================================================");
    }

    private void clearInfo() {
        this.mInfoArea.replaceRange("", 0, this.mInfoArea.getDocument().getLength());
    }

    private void centerThis() {
        this.printInfo("centerThis");
        this.dispose();
        GuiUtilities.setNumberOfMonitors((Integer)this.mNumberOfMonitors.getSelectedItem());
        GuiUtilities.centerWindow(this);
        this.show();
        this.printInfo("This frame is now centered at " + this.getLocation() + " with size of " + this.getSize());
        this.printInfo("==========================================================");
    }

    private void centerOnThis() {
        this.printInfo("centerOnThis");
        GuiUtilities.setNumberOfMonitors((Integer)this.mNumberOfMonitors.getSelectedItem());
        MultiMonitorOptionDialog.showConfirmDialog(this, "This dialog box should be in the center of the parent frame, and not between monitor displays", "Center of Parent Dialog", -1, 1);
        this.printInfo("==========================================================");
    }

    private boolean isMaximized() {
        int n2 = this.getExtendedState();
        return (n2 & 6) != 0;
    }

    public void iconify() {
        this.printInfo("iconify");
        int n2 = this.getExtendedState();
        this.setExtendedState(n2 |= 1);
        this.printInfo("This frame is now iconified at " + this.getLocation() + " with size of " + this.getSize());
        this.printInfo("==========================================================");
    }

    public void deiconify() {
        this.printInfo("deiconify");
        int n2 = this.getExtendedState();
        this.setExtendedState(n2 &= 0xFFFFFFFE);
        this.printInfo("This frame is now deiconified at " + this.getLocation() + " with size of " + this.getSize());
        this.printInfo("==========================================================");
    }

    public void minimize() {
        this.printInfo("unmaximize");
        int n2 = this.getExtendedState();
        this.setExtendedState(n2 &= 0xFFFFFFF9);
        this.printInfo("This frame is now unmaximized at " + this.getLocation() + " with size of " + this.getSize());
        this.printInfo("==========================================================");
    }

    public void maximize() {
        this.printInfo("maximize");
        int n2 = this.getExtendedState();
        this.setExtendedState(n2 |= 6);
        this.printInfo("This frame is now maximized at " + this.getLocation() + " with size of " + this.getSize());
        this.printInfo("==========================================================");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mClose) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.mIconify) {
            this.iconify();
        } else if (actionEvent.getSource() == this.mMinimize) {
            this.minimize();
        } else if (actionEvent.getSource() == this.mMaximize) {
            this.maximize();
        } else if (actionEvent.getSource() == this.mCenterThis) {
            this.centerThis();
        } else if (actionEvent.getSource() == this.mCenterOnThis) {
            this.centerOnThis();
        } else if (actionEvent.getSource() == this.mClear) {
            this.clearInfo();
        } else if (actionEvent.getSource() == this.mGetInfo) {
            this.getInfo();
        }
    }

    public static void main(String[] stringArray) {
        MultiMonitorUtilities multiMonitorUtilities = new MultiMonitorUtilities();
        multiMonitorUtilities.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        multiMonitorUtilities.pack();
        multiMonitorUtilities.setSize(new Dimension(850, 500));
        multiMonitorUtilities.show();
        multiMonitorUtilities.getInfo();
    }
}

