/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Table.ColumnDescription;
import GuiUtilities.Table.ListSelectionListenerFactory;
import GuiUtilities.Table.MasterDetailPanel;
import GuiUtilities.Table.SortableTable;
import GuiUtilities.Table.TableContainer;
import GuiUtilities.Table.TableMouseListener;
import GuiUtilities.Util.DefaultButtonProvider;
import GuiUtilities.Util.QueryPanel;
import RuntimeTool.DebugManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionListener;

public abstract class SearchPane
extends JPanel
implements DefaultButtonProvider,
TableContainer {
    protected Window mParentWindow;
    protected QueryPanel mQueryPanel;
    protected MasterDetailPanelWithMouseListeners mMasterDetailPanel;
    private JPanel mQueryPanelContainer;

    public SearchPane(Window window, String string, ColumnDescription[] columnDescriptionArray, String string2, ColumnDescription[] columnDescriptionArray2) {
        super(new GridBagLayout());
        this.mParentWindow = window;
        this.mQueryPanelContainer = new JPanel();
        this.mQueryPanelContainer.setLayout(new BorderLayout());
        this.mMasterDetailPanel = new MasterDetailPanelWithMouseListeners(string, columnDescriptionArray, string2, columnDescriptionArray2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.mQueryPanelContainer, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.mMasterDetailPanel, gridBagConstraints);
    }

    public MasterDetailPanel getMasterDetailPanel() {
        return this.mMasterDetailPanel;
    }

    protected void setQueryPanel(QueryPanel queryPanel) {
        this.mQueryPanel = queryPanel;
        this.mQueryPanelContainer.removeAll();
        this.mQueryPanelContainer.add((Component)queryPanel, "Center");
        this.invalidate();
    }

    protected abstract void masterSelectionChange(Collection var1);

    protected abstract void masterDoubleClick(Collection var1);

    protected abstract void detailDoubleClick(Collection var1);

    public void setMasterPopupMenu(JPopupMenu jPopupMenu) {
        this.mMasterDetailPanel.setMasterPopupMenu(jPopupMenu);
    }

    public void setDetailPopupMenu(JPopupMenu jPopupMenu) {
        this.mMasterDetailPanel.setDetailPopupMenu(jPopupMenu);
    }

    protected void clearTables() {
        this.mMasterDetailPanel.setMasterTableModel(new ArrayList());
        this.mMasterDetailPanel.setDetailTableModel(new ArrayList());
    }

    protected void showError(String string, String string2, Throwable throwable) {
        DebugManager.getDefault().printException(string, throwable);
        MultiMonitorOptionDialog.showConfirmDialog(this.mParentWindow, string, string2, -1, 0);
    }

    public JButton getDefaultButton() {
        return this.mQueryPanel.getSearchButton();
    }

    public void registerSelectionListeners(ListSelectionListenerFactory listSelectionListenerFactory) {
        MasterDetailPanelWithMouseListeners masterDetailPanelWithMouseListeners = this.mMasterDetailPanel;
        SortableTable sortableTable = masterDetailPanelWithMouseListeners.getMasterTable();
        ListSelectionListener listSelectionListener = listSelectionListenerFactory.createListSelectionListener(sortableTable);
        sortableTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        SortableTable sortableTable2 = masterDetailPanelWithMouseListeners.getDetailTable();
        ListSelectionListener listSelectionListener2 = listSelectionListenerFactory.createListSelectionListener(sortableTable2);
        sortableTable2.getSelectionModel().addListSelectionListener(listSelectionListener2);
    }

    class MasterDetailPanelWithMouseListeners
    extends MasterDetailPanel {
        public MasterDetailPanelWithMouseListeners(String string, ColumnDescription[] columnDescriptionArray, String string2, ColumnDescription[] columnDescriptionArray2) {
            super(string, columnDescriptionArray, string2, columnDescriptionArray2);
        }

        public void setMasterPopupMenu(JPopupMenu jPopupMenu) {
            this.mMasterTable.addMouseListener(new TableMouseListener(this, jPopupMenu){
                private final /* synthetic */ MasterDetailPanelWithMouseListeners this$1;
                {
                    this.this$1 = masterDetailPanelWithMouseListeners;
                    super(jPopupMenu);
                }

                protected void mouseDoubleClicked() {
                    MasterDetailPanelWithMouseListeners.access$000(this.this$1).masterDoubleClick(MasterDetailPanelWithMouseListeners.access$000((MasterDetailPanelWithMouseListeners)this.this$1).mMasterDetailPanel.getMasterSelections());
                }
            });
        }

        public void setDetailPopupMenu(JPopupMenu jPopupMenu) {
            this.mDetailTable.addMouseListener(new TableMouseListener(this, jPopupMenu){
                private final /* synthetic */ MasterDetailPanelWithMouseListeners this$1;
                {
                    this.this$1 = masterDetailPanelWithMouseListeners;
                    super(jPopupMenu);
                }

                protected void mouseDoubleClicked() {
                    MasterDetailPanelWithMouseListeners.access$000(this.this$1).detailDoubleClick(MasterDetailPanelWithMouseListeners.access$000((MasterDetailPanelWithMouseListeners)this.this$1).mMasterDetailPanel.getDetailSelections());
                }
            });
        }

        public void masterSelectionChange(Collection collection) {
            SearchPane.this.masterSelectionChange(collection);
        }

        static /* synthetic */ SearchPane access$000(MasterDetailPanelWithMouseListeners masterDetailPanelWithMouseListeners) {
            return masterDetailPanelWithMouseListeners.SearchPane.this;
        }
    }
}

