/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Icon.IconCache;
import GuiUtilities.Layouts.GridBagBuilder;
import GuiUtilities.Util.CalendarPicker;
import GuiUtilities.Util.GuiUtilities;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class SimpleDatePickerPanel
extends JPanel
implements ActionListener {
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat mDateFormat;
    private JLabel mLabel;
    private JLabel mDatePatternLabel;
    private JFormattedTextField mDateTextField;
    private JButton mCalendarPickerButton;
    private boolean mShowDatePatternLabel;
    private GuiModificationListener mListener;

    public SimpleDatePickerPanel() {
        this("", DEFAULT_DATE_FORMAT, false);
    }

    public SimpleDatePickerPanel(String string, boolean bl2) {
        this(string, DEFAULT_DATE_FORMAT, bl2);
    }

    public SimpleDatePickerPanel(String string, SimpleDateFormat simpleDateFormat) {
        this(string, simpleDateFormat, false);
    }

    public SimpleDatePickerPanel(String string, SimpleDateFormat simpleDateFormat, boolean bl2) {
        this.mLabel = new JLabel(string);
        this.mDateFormat = simpleDateFormat;
        this.createDateTextField();
        this.mShowDatePatternLabel = bl2;
        this.mDatePatternLabel = new JLabel(this.mDateFormat.toPattern());
        this.mDatePatternLabel.setForeground(Color.GRAY);
        this.mDatePatternLabel.setAlignmentX(0.0f);
        IconCache iconCache = new IconCache();
        this.mCalendarPickerButton = new JButton(iconCache.getImageIcon("/GuiUtilities/Icons/date_small.png"));
        this.mCalendarPickerButton.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), new EtchedBorder()));
        this.mCalendarPickerButton.setCursor(new Cursor(12));
        this.mCalendarPickerButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagBuilder gridBagBuilder = new GridBagBuilder().setSize(1, 1).setAnchor(17).setInsets(0, 0, 0, 2);
        this.add((Component)this.mLabel, gridBagBuilder.getConstraints());
        this.add((Component)this.mDateTextField, gridBagBuilder.setLocation(1, 0).setFill(2, 1.0, 0.0).setSize(1, 1).getConstraints());
        this.add((Component)this.mCalendarPickerButton, gridBagBuilder.setLocation(2, 0).setInsets(0, 0, 0, 2).getConstraints());
        if (this.mShowDatePatternLabel) {
            this.add((Component)this.mDatePatternLabel, gridBagBuilder.setLocation(1, 1).getConstraints());
        }
    }

    private void createDateTextField() {
        this.mDateTextField = new JFormattedTextField(this.mDateFormat);
        this.mDateTextField.setColumns(this.mDateFormat.toPattern().length());
        this.mDateTextField.setFocusLostBehavior(3);
        this.mDateTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (StringCheck.isStringBlank(SimpleDatePickerPanel.this.mDateTextField.getText())) {
                    SimpleDatePickerPanel.this.mDateTextField.setText(null);
                    return;
                }
                if (SimpleDatePickerPanel.this.mDateTextField.isEditValid()) {
                    try {
                        SimpleDatePickerPanel.this.mDateTextField.commitEdit();
                    }
                    catch (ParseException parseException) {
                        DebugManager.getDefault().printException("Parse error on valid value!", parseException);
                        SimpleDatePickerPanel.this.mDateTextField.setText(null);
                    }
                } else {
                    SimpleDatePickerPanel.this.mDateTextField.setText(null);
                }
            }
        });
        this.mDateTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                SimpleDatePickerPanel.this.fireGuiModified();
            }
        });
    }

    public Date getDate() {
        String string = this.mDateTextField.getText();
        if (StringCheck.isStringBlank(string)) {
            return null;
        }
        try {
            return this.mDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            DebugManager.getDefault().printException("unexpected exception", parseException);
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mCalendarPickerButton) {
            this.updateDateField(this.mCalendarPickerButton, this.mDateTextField);
            this.fireGuiModified();
        }
    }

    private void updateDateField(JButton jButton, JFormattedTextField jFormattedTextField) {
        Date date = this.getDate();
        if (date == null) {
            date = new Date();
        }
        CalendarPicker calendarPicker = new CalendarPicker((Frame)SwingUtilities.getRoot(this), jFormattedTextField, date);
        Point point = jButton.getLocation();
        SwingUtilities.convertPointToScreen(point, jButton);
        calendarPicker.setLocation(new Point((int)point.getX() - 100, (int)point.getY() - 125));
        calendarPicker.setVisible(true);
    }

    public String getDateString() {
        return this.mDateTextField.getText();
    }

    public void setDate(Date date) {
        if (date == null) {
            this.mDateTextField.setText(null);
        } else {
            this.mDateTextField.setText(this.mDateFormat.format(date));
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Simple Date Picker Panel Test");
        jFrame.getContentPane().add(new SimpleDatePickerPanel("Date", false));
        jFrame.pack();
        GuiUtilities.centerWindow(jFrame);
        jFrame.show();
    }

    public void setGuiModificationListener(GuiModificationListener guiModificationListener) {
        this.mListener = guiModificationListener;
    }

    private void fireGuiModified() {
        if (this.mListener != null) {
            this.mListener.guiModified(this.mDateTextField.getText());
        }
    }

    public static interface GuiModificationListener {
        public void guiModified(String var1);
    }
}

