/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util.TileCacheMonitorTool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

public final class EventViewer
extends JPanel {
    private JTable table;
    private DefaultTableModel model;
    private JScrollPane scrollpane;
    private Object[][] initial_data = new Object[][]{{"-", "-", "-", "-"}};
    private static final Color LIGHT_BLUE = new Color(240, 240, 255);
    private static final Font TABLE_FONT = new Font("monospaced", 1, 12);
    private static final String[] COLUMN_LABELS = new String[]{"JAI Operator", "Event", "Tile Size", "Timestamp"};

    public EventViewer() {
        this.setLayout(new FlowLayout(0, 1, 1));
        this.model = new DefaultTableModel(this.initial_data, COLUMN_LABELS);
        this.table = new JTable(this.model);
        this.table.setFont(TABLE_FONT);
        this.table.setBackground(LIGHT_BLUE);
        this.table.setAutoResizeMode(4);
        this.table.setAutoscrolls(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(90);
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.setHorizontalScrollBarPolicy(31);
        this.scrollpane.setVerticalScrollBarPolicy(22);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bevelBorder = new BevelBorder(1);
        this.scrollpane.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        Dimension dimension = new Dimension(this.scrollpane.getPreferredSize().width + 100, 140);
        this.scrollpane.setPreferredSize(dimension);
        this.add(this.scrollpane);
    }

    public void setRows(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("rows must be greater than 0.");
        }
        int n3 = (int)this.table.getTableHeader().getHeaderRect(0).getHeight();
        int n4 = this.table.getRowHeight() * (n2 + 1) + n3;
        Dimension dimension = new Dimension(this.scrollpane.getPreferredSize().width, n4);
        this.scrollpane.setPreferredSize(dimension);
        this.scrollpane.revalidate();
    }

    public void clear() {
        int n2;
        for (int i2 = n2 = this.model.getRowCount() - 1; i2 >= 0; --i2) {
            this.model.removeRow(i2);
        }
        this.model = new DefaultTableModel(this.initial_data, COLUMN_LABELS);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(90);
    }

    public synchronized void insertRow(int n2, Vector vector) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Rows must be greater or equal to 0.");
        }
        if (vector == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        this.model.insertRow(n2, vector);
    }
}

