/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util.TileCacheMonitorTool;

import GuiUtilities.Util.TileCacheMonitorTool.RingBuffer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public final class MemoryChart
extends JComponent
implements Runnable,
ComponentListener {
    private Thread thread;
    private long delay = 500L;
    private double free_memory;
    private double total_memory;
    private RingBuffer rbuf = new RingBuffer(500);
    private Insets insets = null;
    private int data_length = -1;
    private int percent;
    private int x1 = 0;
    private int y1 = 0;
    private int x2 = 0;
    private int y2 = 0;
    private int w = 0;
    private int h = 0;
    private static final StringBuffer buf1 = new StringBuffer(32);
    private static final StringBuffer buf2 = new StringBuffer(32);
    private static final StringBuffer buf3 = new StringBuffer(32);
    private static final int BAR_WIDTH = 5;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final Color BLUE = new Color(100, 150, 220);
    private static final Color DARK_BLUE = new Color(20, 20, 120);
    private static final Font DEFAULT_FONT = new Font("monospaced", 1, 14);

    public MemoryChart() {
        this.setBackground(Color.gray);
        this.setPreferredSize(new Dimension(480, 140));
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        BevelBorder bevelBorder = new BevelBorder(1);
        this.setBorder(new CompoundBorder(bevelBorder, emptyBorder));
        this.addComponentListener(this);
        this.insets = this.getInsets();
        buf1.append("Alloc Memory: ");
        buf2.append(" Used Memory: ");
        buf3.append("Percent Used: ");
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n2 = this.getWidth() - 5;
        if (this.data_length != n2) {
            this.data_length = n2;
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.data_length = this.getWidth() - 5;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setName("MemoryChartThread");
        this.thread.setPriority(1);
        this.thread.start();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread && !this.isShowing() || this.getSize().width < 5 || this.getSize().height < 5) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        while (this.thread == thread && this.isShowing()) {
            this.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        this.thread = null;
    }

    public void setDelay(long l2) {
        this.delay = l2 > 0L ? l2 : 1L;
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.x1 = this.insets.left;
        this.y1 = this.insets.top;
        this.x2 = this.getWidth() - this.insets.right - 5 - 1;
        this.y2 = this.getHeight() - this.insets.bottom - 1;
        this.w = this.x2 - this.x1 + 1;
        this.h = this.y2 - this.y1 + 1;
        graphics2D.setBackground(Color.darkGray);
        graphics2D.clearRect(this.x1, this.y1, this.w, this.h);
        this.free_memory = RUNTIME.freeMemory();
        this.total_memory = RUNTIME.totalMemory();
        float f2 = 100.0f * (float)((this.total_memory - this.free_memory) / this.total_memory);
        this.rbuf.write(f2);
        int n2 = (int)((float)this.h * this.rbuf.read(this.rbuf.getCount() - 1) / 100.0f);
        this.drawBarGraph(graphics2D, this.x2, this.y2, n2);
        this.drawGrids(graphics2D, this.x1, this.y1, this.w, this.h);
        this.drawLegend(graphics2D);
        this.drawData(graphics2D);
    }

    private void drawGrids(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        graphics2D.setColor(Color.cyan);
        graphics2D.drawRect(n2, n3, n4 + 5 - 1, n5);
        float f2 = (float)(this.y2 - n3) / 10.0f;
        graphics2D.setColor(BLUE);
        for (int i2 = 1; i2 < 10; ++i2) {
            int n6 = (int)((float)i2 * f2) + n3;
            graphics2D.drawLine(n2, n6, this.x2 - 1, n6);
        }
    }

    private void drawBarGraph(Graphics2D graphics2D, int n2, int n3, int n4) {
        graphics2D.setColor(BLUE);
        graphics2D.fillRect(n2, this.y1, 5, this.h);
        graphics2D.setColor(Color.yellow);
        graphics2D.fillRect(n2, n3 - n4, 5, n4 + 1);
    }

    private void drawLegend(Graphics2D graphics2D) {
        this.percent = (int)(100.0f * (float)((this.total_memory - this.free_memory) / this.total_memory));
        graphics2D.setColor(DARK_BLUE);
        graphics2D.fillRect(this.x1 + 5, this.y1 + 5, 200, 50);
        graphics2D.setColor(Color.white);
        graphics2D.setFont(DEFAULT_FONT);
        buf1.delete(14, 31);
        buf1.append((long)this.total_memory);
        graphics2D.drawString(buf1.toString(), this.insets.left + 10, this.insets.top + 20);
        buf2.delete(14, 31);
        buf2.append((long)(this.total_memory - this.free_memory));
        graphics2D.drawString(buf2.toString(), this.insets.left + 10, this.insets.top + 35);
        buf3.delete(14, 31);
        buf3.append(this.percent + "%");
        graphics2D.drawString(buf3.toString(), this.insets.left + 10, this.insets.top + 50);
    }

    private void drawData(Graphics2D graphics2D) {
        graphics2D.setColor(Color.yellow);
        float f2 = (float)(this.w - 5 + 3) / ((float)this.rbuf.getSize() - 1.0f);
        for (int i2 = 1; i2 < this.rbuf.getCount(); ++i2) {
            float f3 = this.rbuf.read(i2 - 1) / 100.0f;
            float f4 = this.rbuf.read(i2) / 100.0f;
            int n2 = this.x1 + (int)((float)(i2 - 1) * f2);
            int n3 = this.y2 - (int)((float)this.h * f3);
            int n4 = this.x1 + (int)((float)i2 * f2);
            int n5 = this.y2 - (int)((float)this.h * f4);
            graphics2D.drawLine(n2, n3, n4, n5);
        }
    }
}

