/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Worker;

import GuiUtilities.Worker.Worker;
import com.intelerad.tools.lib.concurrent.CallAdapter;
import com.intelerad.tools.lib.concurrent.Callable;
import com.intelerad.tools.lib.concurrent.CallableUtilities;
import com.intelerad.tools.lib.concurrent.ExecutionException;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.TaskController;

public class WorkerController
implements TaskController {
    private final Worker mWorker;
    private TaskController mTaskController;
    private boolean mStarted = false;

    public WorkerController(Worker worker) {
        this.mWorker = worker;
    }

    public synchronized void start() {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return WorkerController.this.mWorker.call();
            }
        };
        CallAdapter callAdapter = new CallAdapter(){

            public void handleCancel() {
                WorkerController.this.mWorker.handleCancel();
            }

            public void handleSuccess(Object object) {
                WorkerController.this.mWorker.handleSuccess(object);
            }

            public void handleException(Exception exception) {
                WorkerController.this.mWorker.handleException(exception);
            }
        };
        this.mTaskController = CallableUtilities.execute(callable, callAdapter, Invoker.EVENT_THREAD_INVOKER);
        this.mStarted = true;
    }

    public synchronized Object get() throws ExecutionException, InterruptedException {
        this.checkIfStarted();
        return this.mTaskController.get();
    }

    public synchronized boolean isCancelled() {
        this.checkIfStarted();
        return this.mTaskController.isCancelled();
    }

    public synchronized boolean isDone() {
        this.checkIfStarted();
        return this.mTaskController.isDone();
    }

    public synchronized void cancel() {
        this.checkIfStarted();
        this.mTaskController.cancel();
    }

    private void checkIfStarted() {
        if (!this.mStarted) {
            throw new IllegalStateException("Can't call methods other than start() of Worker controller before start()");
        }
    }
}

