/*
 * Decompiled with CFR 0.152.
 */
package HttpUtilities;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class UriBuilder {
    private String mBaseUri;
    private String mPath;
    private List mParameters = new ArrayList();

    public UriBuilder() {
        this((String)null, null);
    }

    public UriBuilder(String string) {
        this((String)null, string);
    }

    public UriBuilder(URL uRL, String string) {
        this(uRL.toString(), string);
    }

    public UriBuilder(URI uRI, String string) {
        this(uRI.toString(), string);
    }

    public UriBuilder(String string, String string2) {
        this.mBaseUri = string;
        this.mPath = string2;
    }

    public void addParameter(String string, Object object) {
        String string2;
        if (string == null) {
            throw new NullPointerException("null parameter name passed");
        }
        if (object == null) {
            throw new NullPointerException("null value for parameter '" + string + "'");
        }
        try {
            string = URLEncoder.encode(string, "UTF-8");
            string2 = URLEncoder.encode(object.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("URLEncoder.encode() couldn't handle UTF-8 encoding", unsupportedEncodingException);
        }
        this.mParameters.add(new String[]{string, string2});
    }

    public String getQuery() {
        if (this.mParameters.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.mParameters.size(); ++i2) {
            String[] stringArray = (String[])this.mParameters.get(i2);
            stringBuffer.append(stringArray[0]);
            stringBuffer.append("=");
            stringBuffer.append(stringArray[1]);
            if (i2 >= this.mParameters.size() - 1) continue;
            stringBuffer.append("&");
        }
        return stringBuffer.toString();
    }

    public String getUriString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mBaseUri != null) {
            stringBuffer.append(this.mBaseUri);
        }
        if (this.mPath != null) {
            stringBuffer.append(this.mPath);
        }
        if ((string = this.getQuery()) != null) {
            stringBuffer.append('?').append(string);
        }
        return stringBuffer.toString();
    }

    public URI getUri() {
        try {
            return new URI(this.getUriString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Error creating URI object", uRISyntaxException);
        }
    }

    public URL getUrl() {
        if (this.mBaseUri == null) {
            throw new IllegalStateException("cannot get URL object when base URL is null");
        }
        try {
            String string = this.getQuery();
            URL uRL = new URL(this.mBaseUri);
            if (string == null) {
                return new URL(uRL, this.mPath);
            }
            return new URL(uRL, this.mPath + "?" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Error creating URL object", malformedURLException);
        }
    }

    public String toString() {
        return this.getUriString();
    }
}

