/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Pacs;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.intelerad.lib.dicomtools.PrivateElement;

public class MoveRequest {
    private static final String STUDY_LEVEL = "STUDY";
    private static final String SERIES_LEVEL = "SERIES";
    private String mCurrentUidLevel = "";
    private String mStudyUid = "";
    private String mSeriesUid = "";
    private boolean mPendingCMove = false;

    public MoveRequest() {
    }

    public MoveRequest(MoveRequest moveRequest) {
        this.mCurrentUidLevel = moveRequest.mCurrentUidLevel;
        this.mStudyUid = moveRequest.mStudyUid;
        this.mSeriesUid = moveRequest.mSeriesUid;
        this.mPendingCMove = moveRequest.mPendingCMove;
    }

    public static String getStudyUidLevel() {
        return STUDY_LEVEL;
    }

    public static String getSeriesUidLevel() {
        return SERIES_LEVEL;
    }

    public void setStudyLevelUid(String string) {
        this.mStudyUid = string;
        this.mSeriesUid = "";
        this.mCurrentUidLevel = STUDY_LEVEL;
    }

    public void setSeriesLevelUids(String string, String string2) {
        this.mStudyUid = string;
        this.mSeriesUid = string2;
        this.mCurrentUidLevel = SERIES_LEVEL;
    }

    public void setPendingMove(boolean bl2) {
        this.mPendingCMove = bl2;
    }

    public DicomObject getDicomObject() throws DicomException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(78, (Object)this.mCurrentUidLevel);
        if (this.mCurrentUidLevel.equals(STUDY_LEVEL)) {
            dicomObject.set(425, (Object)this.mStudyUid);
        } else if (this.mCurrentUidLevel.equals(SERIES_LEVEL)) {
            dicomObject.set(425, (Object)this.mStudyUid);
            dicomObject.set(426, (Object)this.mSeriesUid);
        } else {
            throw new IllegalArgumentException("Cannot get DicomObject for move request that supports UID Level = " + this.mCurrentUidLevel);
        }
        if (this.mPendingCMove) {
            PrivateElement.setImsDelayedMoveRequest(dicomObject, this.mPendingCMove, true);
        }
        return dicomObject;
    }

    public String toString() {
        String string = this.mCurrentUidLevel;
        String string2 = SERIES_LEVEL.equals(this.mCurrentUidLevel) ? "Series instance UID: " + this.mSeriesUid : "Study instance UID: " + this.mStudyUid;
        return "MoveRequest - Level: " + string + " " + string2;
    }

    public static MoveRequest createSeriesMoveRequest(String string, String string2) {
        MoveRequest moveRequest = new MoveRequest();
        moveRequest.setSeriesLevelUids(string, string2);
        return moveRequest;
    }

    public static MoveRequest createStudyMoveRequest(String string) {
        MoveRequest moveRequest = new MoveRequest();
        moveRequest.setStudyLevelUid(string);
        return moveRequest;
    }
}

