/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Services;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class DimseMessage {
    final DicomObject mHeader;
    final DicomObject mData;

    public DimseMessage(DicomObject dicomObject, DicomObject dicomObject2) {
        this.mHeader = dicomObject;
        this.mData = dicomObject2;
    }

    public DimseMessage(DicomObject dicomObject) {
        this.mHeader = dicomObject;
        this.mData = null;
    }

    public DicomObject getHeader() {
        return this.mHeader;
    }

    public DicomObject getData() {
        return this.mData;
    }

    public String getAffectedInstanceUid() throws DicomException {
        return this.mHeader.getS(13);
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.println("Header:");
            this.getHeader().dumpVRs((OutputStream)printStream);
            printStream.println("Data:");
            if (this.mData != null) {
                this.getData().dumpVRs((OutputStream)printStream);
            } else {
                printStream.println("<no data>");
            }
            printStream.close();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected exception: " + iOException.toString());
        }
    }
}

