/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Services;

import InteleDicomLibrary.Services.DicomConnectionParameters;
import InteleDicomLibrary.Services.Scu;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.DimseUtil;
import java.io.IOException;

public class MoveScu
extends Scu {
    private static final String mDebugKey = "MoveScu";

    public MoveScu(String string, int n2, String string2, String string3) {
        super(string, n2, string2, string3);
    }

    public MoveScu(DicomConnectionParameters dicomConnectionParameters) {
        super(dicomConnectionParameters);
    }

    public boolean moveStudies(DicomObject dicomObject, String string) {
        try {
            if (!this.associate(4136)) {
                return false;
            }
            this.mDebug.print(mDebugKey, "Association accepted for StudyRootQueryRetrieveInformationModelMOVE");
            if (!this.exchangeMove(mMessageId, dicomObject, string)) {
                return false;
            }
            this.mDebug.print(mDebugKey, "Move accepted");
            if (!this.release()) {
                return false;
            }
            this.mDebug.print(mDebugKey, "Successful release of association.");
            this.mErrorDetails = "";
            return true;
        }
        catch (IOException iOException) {
            this.mDebug.printStackTrace(iOException);
            this.mErrorDetails = iOException.toString();
            return false;
        }
        catch (IllegalValueException illegalValueException) {
            this.mDebug.printStackTrace(illegalValueException);
            this.mErrorDetails = illegalValueException.toString();
            return false;
        }
        catch (DicomException dicomException) {
            this.mDebug.printStackTrace(dicomException);
            this.mErrorDetails = dicomException.toString();
            return false;
        }
        catch (UnknownUIDException unknownUIDException) {
            this.mDebug.printStackTrace(unknownUIDException);
            this.mErrorDetails = unknownUIDException.toString();
            return false;
        }
    }

    private boolean exchangeMove(int n2, DicomObject dicomObject, String string) throws DicomException, IllegalValueException, IOException, UnknownUIDException {
        Integer n3;
        DicomObject dicomObject2 = DimseUtil.createMoveRequest((Integer)new Integer(n2), (Integer)new Integer(4136), (Integer)new Integer(1), (String)string);
        this.mAssociation.sendInPresentationContext(this.mPresentationContextId, dicomObject2, dicomObject);
        DicomObject dicomObject3 = null;
        this.mSubOperationCounter = 0;
        do {
            dicomObject3 = this.mAssociation.receiveCommand();
            ++this.mSubOperationCounter;
            n3 = new Integer(dicomObject3.getI(9));
            this.mDebug.print(mDebugKey, "Move response status = " + n3.toString() + " [" + mStatusCodes.get(n3) + "]");
            if (!PENDING_SUB_OPERATIONS.equals(n3)) continue;
            n3 = new Integer(this.storeMoveResponse(n2, dicomObject3));
        } while (PENDING_SUB_OPERATIONS.equals(n3));
        if (!SUCCESS.equals(n3)) {
            this.mErrorDetails = "Non successful status in C-MOVE RESPONSE: 0x" + Integer.toHexString(n3).toUpperCase() + " [" + mStatusCodes.get(n3) + "]" + ". Aborting association.";
            this.mDebug.printError(this.mErrorDetails);
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return false;
        }
        this.mErrorDetails = "";
        this.mDebug.print(mDebugKey, "Successful move, " + this.mSubOperationCounter + " sub-operations completed.");
        return true;
    }

    private int storeMoveResponse(int n2, DicomObject dicomObject) throws IOException, IllegalValueException, DicomException, UnknownUIDException {
        this.mDebug.print(mDebugKey, "*** C-MOVE SUB-OPERATION RESPONSE ***");
        this.mDebug.print(mDebugKey, "Received commandtype: " + DimseUtil.getCommandName((int)DimseUtil.getCommandType((DicomObject)dicomObject)));
        if (DimseUtil.getCommandType((DicomObject)dicomObject) != 32801) {
            this.mDebug.printError("No C-MOVE RESPONSE command field : " + DimseUtil.getCommandType((DicomObject)dicomObject) + ". Aborting association");
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return -1;
        }
        if (DimseUtil.getAffectedSOPClass((DicomObject)dicomObject) != 4136) {
            this.mDebug.printError("Affected SOP Class UID in C-MOVE RESPONSE wrong: expecting [4136], received [" + DimseUtil.getAffectedSOPClass((DicomObject)dicomObject) + "]" + ". Aborting association");
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return -1;
        }
        if (DimseUtil.getMessageIDBeingRespondedTo((DicomObject)dicomObject) != n2) {
            this.mDebug.printError("Message ID in C-MOVE RESPONSE wrong: expecting [" + n2 + "], received [" + DimseUtil.getMessageIDBeingRespondedTo((DicomObject)dicomObject) + "]" + ". Aborting association");
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return -1;
        }
        return dicomObject.getI(9);
    }
}

