/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Services;

import InteleDicomLibrary.Services.DicomConnectionParameters;
import RuntimeTool.Debug;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Scu {
    private static final String mDebugKey = "Scu";
    protected static final Integer DATASET_TYPE_NO_DATA = new Integer(257);
    protected static final Integer OUT_OF_RESOURCES_SYSTEM_FAILURE = new Integer(42753);
    protected static final Integer OUT_OF_RESOURCES_SUB_OPERATION = new Integer(42754);
    protected static final Integer SEARCH_IDENTIFIER_NOT_MATCH = new Integer(43264);
    protected static final Integer UNABLE_TO_PROCESS_REQUEST_0 = new Integer(49152);
    protected static final Integer UNABLE_TO_REQUEST_REQUEST_1 = new Integer(49153);
    protected static final Integer CANCEL_REQUEST = new Integer(65024);
    protected static final Integer SUB_OPERATIONS_COMPLETE_WITH_FAIL = new Integer(45056);
    protected static final Integer SUCCESS = new Integer(0);
    protected static final Integer PENDING_SUB_OPERATIONS = new Integer(65280);
    protected static final Integer PENDING_SUB_OPERATIONS_WITH_WARNING = new Integer(65281);
    protected static int mMessageId = 88;
    protected static int mMaxPdu = 0;
    protected static int mPreferredTransferSyntax = 8193;
    protected static int[] mTransferSyntaxArray = new int[]{mPreferredTransferSyntax};
    protected String mErrorDetails = "";
    protected String mHost;
    protected int mPort;
    protected String mCalledAe;
    protected String mCallingAe;
    protected int mPresentationContextId;
    protected Association mAssociation;
    protected Request mRequest;
    protected Debug mDebug = new Debug();
    protected int mSubOperationCounter = 0;
    private Socket mSocket = null;
    protected static Hashtable mStatusCodes = new Hashtable();

    public Scu(DicomConnectionParameters dicomConnectionParameters) {
        this(dicomConnectionParameters.getHost(), dicomConnectionParameters.getPort(), dicomConnectionParameters.getCalledAe(), dicomConnectionParameters.getCallingAe());
    }

    public Scu(String string, int n2, String string2, String string3) {
        this.mHost = string;
        this.mPort = n2;
        this.mCalledAe = string2;
        this.mCallingAe = string3;
        this.mSocket = new Socket();
    }

    public void setDebug(Debug debug) {
        this.mDebug = debug;
        this.mDebug.print(mDebugKey, "Scu initialized with Host = " + this.mHost + ", Port = " + this.mPort + ", CalledAe = " + this.mCalledAe + ", CallingAe = " + this.mCallingAe);
    }

    public String getErrorDetails() {
        return this.mErrorDetails;
    }

    public int getNumberOfSubOperations() {
        return this.mSubOperationCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean associate(int n2) throws IOException, IllegalValueException, UnknownUIDException {
        InetAddress inetAddress = InetAddress.getByName(this.mHost);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.mPort);
        this.mSocket.connect(inetSocketAddress);
        this.mAssociation = new Association(this.mSocket.getInputStream(), this.mSocket.getOutputStream());
        this.mAssociation.setImplementationVersionName("IMS3-4-1-P107");
        this.mAssociation.setImplementationClassUID("1.2.840.114202.5.3");
        this.mRequest = new Request();
        this.mRequest.setCalledTitle(this.mCalledAe);
        this.mRequest.setCallingTitle(this.mCallingAe);
        this.mRequest.setMaxPduSize(mMaxPdu);
        this.mRequest.addPresentationContext(n2, mTransferSyntaxArray);
        this.mDebug.print(mDebugKey, this.mRequest.toString());
        this.mAssociation.sendAssociateRequest(this.mRequest);
        Response response = null;
        try {
            response = this.mAssociation.receiveAssociateResponse();
            if (response instanceof Acknowledge) {
                Acknowledge acknowledge = (Acknowledge)response;
                this.mDebug.print(mDebugKey, "Association accepted: " + acknowledge.toString());
                this.mPresentationContextId = this.getPresentationContextId(this.getUsablePresentationContextIndices(acknowledge, n2), acknowledge);
                this.mDebug.print(mDebugKey, "Using mPresentationContextId = " + this.mPresentationContextId);
                this.mErrorDetails = "";
                boolean bl2 = true;
                return bl2;
            }
            if (response instanceof Reject) {
                this.mErrorDetails = "Association rejected: " + response.toString();
                this.mDebug.printError(this.mErrorDetails);
                boolean bl3 = false;
                return bl3;
            }
            if (response instanceof Abort) {
                this.mErrorDetails = "Association aborted: " + response.toString();
                this.mDebug.printError(this.mErrorDetails);
                boolean bl4 = false;
                return bl4;
            }
            this.mErrorDetails = "Unknown association type: " + response.toString();
            this.mDebug.printError(this.mErrorDetails);
            boolean bl5 = false;
            return bl5;
        }
        finally {
            response = null;
            this.mRequest = null;
        }
    }

    protected int getPresentationContextId(List list, Acknowledge acknowledge) {
        int n2 = this.mRequest.getID(((Integer)list.get(0)).intValue());
        block0: for (int i2 = 0; i2 < list.size(); ++i2) {
            for (int i3 = 0; i3 < acknowledge.getPresentationContexts(); ++i3) {
                if (acknowledge.getID(i3) != this.mRequest.getID(((Integer)list.get(i2)).intValue()) || acknowledge.getTransferSyntax(i3).getConstant() != mPreferredTransferSyntax) continue;
                n2 = acknowledge.getID(i3);
                break block0;
            }
        }
        return n2;
    }

    protected List getUsablePresentationContextIndices(Acknowledge acknowledge, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.mRequest.getPresentationContexts(); ++i2) {
            if (this.mRequest.getAbstractSyntax(i2).getConstant() != n2) continue;
            for (int i3 = 0; i3 < acknowledge.getPresentationContexts(); ++i3) {
                if (this.mRequest.getID(i2) != acknowledge.getID(i3) || acknowledge.getResult(i3) != 0) continue;
                arrayList.add(new Integer(i2));
            }
        }
        return arrayList;
    }

    protected void close() {
        try {
            this.mSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean release() throws IOException, IllegalValueException {
        try {
            if (this.mAssociation != null) {
                this.mDebug.print(mDebugKey, "Sending release request");
                this.mAssociation.sendReleaseRequest();
                this.mAssociation.receiveReleaseResponse();
                this.mDebug.print(mDebugKey, "Received release response");
                this.mAssociation = null;
            }
        }
        finally {
            this.close();
        }
        this.mErrorDetails = "";
        return true;
    }

    public static void throwDicomException(Exception exception) throws DicomException {
        if (exception instanceof DicomException) {
            throw (DicomException)((Object)exception);
        }
        DicomException dicomException = new DicomException(exception.getMessage());
        dicomException.initCause((Throwable)exception);
        throw dicomException;
    }

    static {
        mStatusCodes.put(OUT_OF_RESOURCES_SYSTEM_FAILURE, "Out Of Resources - System failure");
        mStatusCodes.put(OUT_OF_RESOURCES_SUB_OPERATION, "Out Of Resources - Sub-operation Cannot be performed");
        mStatusCodes.put(SEARCH_IDENTIFIER_NOT_MATCH, "Search Identifier does not match SOP class");
        mStatusCodes.put(UNABLE_TO_PROCESS_REQUEST_0, "Unable to process request - Data set cannot be parsed into elements");
        mStatusCodes.put(UNABLE_TO_REQUEST_REQUEST_1, "Unable to process request");
        mStatusCodes.put(CANCEL_REQUEST, "Matching terminated due to Cancel Request");
        mStatusCodes.put(SUB_OPERATIONS_COMPLETE_WITH_FAIL, "Sub-operations complete with one or more failures");
        mStatusCodes.put(SUCCESS, "Success");
        mStatusCodes.put(PENDING_SUB_OPERATIONS, "Pending sub-operations");
    }
}

