/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import DateUtilities.DateUtilities;
import J2cProtocol.DisplayShutter;
import J2cProtocol.ImageAcquisitionMatrix;
import J2cProtocol.J2cMissingValueException;
import J2cProtocol.SeriesHeader;
import StringUtilities.StringCheck;
import com.archimed.dicom.DDate;
import com.archimed.dicom.Person;

public abstract class AbstractSeriesHeader
extends SeriesHeader {
    protected static final int NUM_SPATIAL_DIMENSIONS = 3;

    private int getIntegerElement(int n2, int n3) throws J2cMissingValueException {
        this.checkIndex(n2);
        Integer n4 = (Integer)this.getElementValue(n2, n3);
        if (n4 == null) {
            throw new J2cMissingValueException("Expected element not found in DICOM object");
        }
        return n4;
    }

    private String getIntegerElementAsString(int n2, int n3) {
        this.checkIndex(n2);
        Integer n4 = (Integer)this.getElementValue(n2, n3);
        return n4 == null ? "" : n4.toString();
    }

    private String getIntegerElementAsString(int n2) {
        return this.getIntegerElementAsString(0, n2);
    }

    private double getDoubleElement(int n2, int n3) throws J2cMissingValueException {
        this.checkIndex(n2);
        Number number = (Number)this.getElementValue(n2, n3);
        if (number == null) {
            throw new J2cMissingValueException("Expected element not found in DICOM object");
        }
        return number.doubleValue();
    }

    private String getDateElementAsString(int n2, int n3) {
        this.checkIndex(n2);
        DDate dDate = (DDate)this.getElementValue(n2, n3);
        return dDate == null ? "" : dDate.toDICOMString();
    }

    private String getDateElementAsString(int n2) {
        return this.getDateElementAsString(0, n2);
    }

    private String getPersonNameElementAsString(int n2) {
        Person person = (Person)this.getElementValue(n2);
        return person == null ? "" : person.toDICOMString().trim();
    }

    public final String getStudyInstanceUid() {
        return this.getElementUiString(425);
    }

    public final String getStudyId() {
        return this.getElementUiString(427);
    }

    public final String getStudyDate() {
        return this.getDateElementAsString(64);
    }

    public final String getStudyTime() {
        return this.getElementUiString(70);
    }

    public final String getStudyDescription() {
        return this.getElementUiString(95);
    }

    public final String getStudyAccessionNumber() {
        return this.getElementUiString(77);
    }

    public final String getStudyReferringPhysiciansName() {
        return this.getPersonNameElementAsString(88);
    }

    public final String getRequestedProcedureId() {
        Object[] objectArray = (Object[])this.getElementValue(589);
        if (objectArray == null || objectArray.length < 1) {
            return "";
        }
        return (String)objectArray[0];
    }

    public final String getSeriesInstanceUid() {
        return this.getElementUiString(426);
    }

    public final String getSeriesDate() {
        return this.getDateElementAsString(65);
    }

    public final String getSeriesTime() {
        return this.getElementUiString(71);
    }

    public final String getSeriesDescription() {
        return this.getElementUiString(97);
    }

    public final String getSeriesNumber() {
        return this.getIntegerElementAsString(428);
    }

    public final String getSeriesModality() {
        return this.getElementUiString(81);
    }

    public final String getSeriesInstitutionName() {
        return this.getElementUiString(85);
    }

    public final String getFrameOfReferenceUid() {
        return this.getElementUiString(442);
    }

    public final String getImageAcquisitionNumber(int n2) {
        return this.getIntegerElementAsString(n2, 429);
    }

    public final String getPatientName() {
        return this.getPersonNameElementAsString(147);
    }

    public final String getPatientId() {
        return this.getElementUiString(148);
    }

    public final String getPatientBirthDate() {
        return this.getDateElementAsString(150);
    }

    public final String getPatientSex() {
        return this.getElementUiString(152);
    }

    public final String getPatientAge() {
        if (StringCheck.isStringBlank(this.getPatientBirthDate()) || StringCheck.isStringBlank(this.getStudyDate())) {
            return this.getElementUiString(157);
        }
        return DateUtilities.getDicomAge(this.getPatientBirthDate(), this.getStudyDate());
    }

    public abstract int getNumberOfImages();

    public abstract int getImagePixelValueShift(int var1) throws J2cMissingValueException;

    public final String getImageSopInstanceUid(int n2) {
        return this.getElementUiString(n2, 63);
    }

    public abstract String getImageJ2cFileName(int var1);

    public final int getImageInstanceNumber(int n2) throws J2cMissingValueException {
        return this.getIntegerElement(n2, 430);
    }

    public final int getImageEchoNumber(int n2) throws J2cMissingValueException {
        return this.getIntegerElement(n2, 219);
    }

    public abstract int getImageFrameNumber(int var1) throws J2cMissingValueException;

    public final int getImageNumberOfFrames(int n2) throws J2cMissingValueException {
        return this.getIntegerElement(n2, 464);
    }

    public final String getImagePhotometricInterpretation(int n2) {
        return this.getElementUiString(n2, 462);
    }

    public final int getImageRows(int n2) throws J2cMissingValueException {
        return this.getIntegerElement(n2, 466);
    }

    public final int getImageColumns(int n2) throws J2cMissingValueException {
        return this.getIntegerElement(n2, 467);
    }

    public abstract boolean hasImagePercentile(int var1, String var2);

    public abstract double getImagePercentile(int var1, String var2) throws J2cMissingValueException;

    public final double getImageWindowLevelCentre(int n2) throws J2cMissingValueException {
        return this.getDoubleElement(n2, 487);
    }

    public final double getImageWindowLevelWidth(int n2) throws J2cMissingValueException {
        return this.getDoubleElement(n2, 488);
    }

    public final double getImageRescaleIntercept(int n2) throws J2cMissingValueException {
        return this.getDoubleElement(n2, 489);
    }

    public final double getImageRescaleSlope(int n2) throws J2cMissingValueException {
        return this.getDoubleElement(n2, 490);
    }

    public final ImageAcquisitionMatrix getImageAcquisitionMatrix(int n2) {
        Object[] objectArray = (Object[])this.getElementValue(n2, 330);
        if (objectArray == null || objectArray.length < 4) {
            return null;
        }
        return new ImageAcquisitionMatrix((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
    }

    public abstract DisplayShutter getImageDisplayShutter(int var1);
}

