/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.ActiveImageSet;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class ActiveImageRequestMessage
extends Message {
    protected ActiveImageSet mActiveImages;

    public ActiveImageRequestMessage() {
        this.mActiveImages = new ActiveImageSet();
    }

    public ActiveImageRequestMessage(ActiveImageSet activeImageSet) {
        this.mActiveImages = new ActiveImageSet(activeImageSet);
    }

    public void setActiveImages(ActiveImageSet activeImageSet) {
        this.mActiveImages.clear();
        this.mActiveImages.addAll(activeImageSet);
    }

    public ActiveImageSet getActiveImages() {
        return this.mActiveImages;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        int n2 = dataInputStream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mActiveImages.add(new Integer(dataInputStream.readInt()));
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        dataOutputStream.writeInt(this.mActiveImages.size());
        Iterator iterator = this.mActiveImages.iterator();
        while (iterator.hasNext()) {
            dataOutputStream.writeInt((Integer)iterator.next());
        }
    }

    public int getLength() {
        return 4 * (1 + this.mActiveImages.size());
    }

    public int getCode() {
        return 11;
    }

    public String toString() {
        return this.mActiveImages.toString();
    }
}

