/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ActiveImageSet {
    private static final int ALLOCATION_MARGIN = 10;
    private SortedSet mActiveImages = new TreeSet();
    private boolean mNeedDistanceUpdate = true;
    private int mSmallestIndex;
    private int mLargestIndex;
    private int[] mActiveImageDistance = null;

    public ActiveImageSet() {
    }

    public ActiveImageSet(ActiveImageSet activeImageSet) {
        this.addAll(activeImageSet);
    }

    public synchronized int size() {
        return this.mActiveImages.size();
    }

    public synchronized boolean addAll(Collection collection) {
        boolean bl2 = this.mActiveImages.addAll(collection);
        if (bl2) {
            this.mNeedDistanceUpdate = true;
        }
        return bl2;
    }

    public synchronized boolean addAll(ActiveImageSet activeImageSet) {
        return this.addAll(activeImageSet.mActiveImages);
    }

    public synchronized boolean add(Object object) {
        return this.mActiveImages.add(object);
    }

    public synchronized void clear() {
        this.mActiveImages.clear();
        this.mNeedDistanceUpdate = true;
    }

    public synchronized Iterator iterator() {
        return this.mActiveImages.iterator();
    }

    public synchronized boolean contains(Object object) {
        return this.mActiveImages.contains(object);
    }

    public synchronized boolean imagesMatch(ActiveImageSet activeImageSet) {
        if (activeImageSet == null || activeImageSet.size() != this.size()) {
            return false;
        }
        Iterator iterator = activeImageSet.iterator();
        Iterator iterator2 = this.iterator();
        while (iterator.hasNext()) {
            Object e2;
            Object e3 = iterator.next();
            if (e3.equals(e2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized int getDistanceToActiveImage(int n2) {
        this.updateDistance();
        if (this.mActiveImages.size() == 0) {
            return 0x3FFFFFFF;
        }
        int n3 = n2 - this.mSmallestIndex;
        int n4 = this.mActiveImageDistance.length - 1;
        if (n3 > n4) {
            return this.mActiveImageDistance[n4] + n3 - n4;
        }
        if (n3 < 0) {
            return this.mActiveImageDistance[0] - n3;
        }
        return this.mActiveImageDistance[n3];
    }

    private void updateDistance() {
        if (this.mNeedDistanceUpdate) {
            this.computeDistances();
            this.mNeedDistanceUpdate = false;
        }
    }

    private void computeDistances() {
        int n2;
        this.findImageIndexRange();
        int n3 = this.mLargestIndex - this.mSmallestIndex + 1;
        if (this.mActiveImageDistance == null || n3 > this.mActiveImageDistance.length) {
            this.mActiveImageDistance = new int[n3 + 10];
        }
        for (int i2 = 0; i2 < this.mActiveImageDistance.length; ++i2) {
            this.mActiveImageDistance[i2] = -1;
        }
        Iterator iterator = this.mActiveImages.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            this.mActiveImageDistance[n2 - this.mSmallestIndex] = 0;
        }
        int n4 = -1073741824;
        n2 = -1;
        for (int i3 = 0; i3 < this.mActiveImageDistance.length; ++i3) {
            int n5;
            int n6;
            int n7 = i3 + this.mSmallestIndex;
            if (this.mActiveImageDistance[i3] == 0) {
                n4 = n7;
                n2 = -1;
                continue;
            }
            if (n2 < n7) {
                for (n2 = n7 + 1; n2 <= this.mLargestIndex && this.mActiveImageDistance[n2 - this.mSmallestIndex] != 0; ++n2) {
                }
                if (n2 > this.mLargestIndex) {
                    n2 = 0x3FFFFFFF;
                }
            }
            if ((n6 = n7 - n4) > (n5 = n2 - n7)) {
                n6 = n5;
            }
            this.mActiveImageDistance[i3] = n6;
        }
    }

    private void findImageIndexRange() {
        this.mSmallestIndex = 0;
        this.mLargestIndex = 0;
        if (this.mActiveImages.size() == 0) {
            return;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        Iterator iterator = this.mActiveImages.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            if (n4 > n3) {
                n3 = n4;
            }
            if (n4 >= n2) continue;
            n2 = n4;
        }
        this.mSmallestIndex = n2;
        this.mLargestIndex = n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Active images:");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            stringBuffer.append(" ");
            stringBuffer.append(n2.toString());
        }
        return stringBuffer.toString();
    }
}

