/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.State;
import J2cProtocol.VariableBlockInputStream;
import J2cProtocol.VariableBlockOutputStream;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.intelerad.lib.dicomtools.JdtUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DicomReplyMessage
extends Message {
    private List mDicomObjectList;

    public DicomReplyMessage() {
    }

    public DicomReplyMessage(List list) {
        this.setDicomObjectList(list);
    }

    public void setDicomObjectList(List list) {
        this.mDicomObjectList = new ArrayList(list);
    }

    public List getDicomObjectList() {
        return this.mDicomObjectList;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        this.setDicomObjectList(DicomReplyMessage.readZippedDicom(new VariableBlockInputStream(dataInputStream)));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        DicomReplyMessage.writeZippedDicom(new VariableBlockOutputStream(dataOutputStream), this.mDicomObjectList);
    }

    private static String getSopInstanceUid(DicomObject dicomObject) throws DicomException {
        return dicomObject.getS(63);
    }

    public int getLength() {
        return 0;
    }

    public int getCode() {
        return 17;
    }

    public void validateMessage(State state) throws J2cProtocolException {
        this.validateMessage(state, State.ESTABLISHING_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readZippedDicom(InputStream inputStream) throws IOException, J2cProtocolException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            DicomObject dicomObject;
            DicomReader dicomReader = new DicomReader();
            dicomReader.addTagReadListener((TagReadListener)new SkipIconImageTagReadListener(), 699);
            DicomObject dicomObject2 = new ArrayList();
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().endsWith(".dcm")) {
                    try {
                        dicomObject = dicomReader.read((InputStream)zipInputStream, true);
                        dicomObject2.add(dicomObject);
                    }
                    catch (DicomException dicomException) {
                        throw new J2cProtocolException(dicomException.toString() + ": reading file " + zipEntry.getName(), dicomException);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            dicomObject = dicomObject2;
            return dicomObject;
        }
        finally {
            zipInputStream.close();
        }
    }

    public static void writeZippedDicom(OutputStream outputStream, List list) throws IOException, J2cProtocolException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DicomObject dicomObject = (DicomObject)iterator.next();
                ZipEntry zipEntry = new ZipEntry(DicomReplyMessage.getSopInstanceUid(dicomObject) + ".dcm");
                zipOutputStream.putNextEntry(zipEntry);
                dicomObject.write((OutputStream)zipOutputStream, true);
                zipOutputStream.closeEntry();
            }
        }
        catch (DicomException dicomException) {
            throw new J2cProtocolException(dicomException);
        }
        finally {
            zipOutputStream.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("Usage: DicomReplyMessage in.zip out.zip");
            System.exit(-1);
        }
        String string = stringArray[0];
        System.out.println("Reading from zip file " + string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        List list = DicomReplyMessage.readZippedDicom(bufferedInputStream);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DicomObject dicomObject = (DicomObject)iterator.next();
            System.out.println("\nDumping DicomObject:\n");
            dicomObject.dumpVRs((OutputStream)System.out);
        }
        System.out.println("Writing to zip file");
        DicomReplyMessage.writeZippedDicom(new FileOutputStream(stringArray[1]), list);
    }

    private static class SkipIconImageTagReadListener
    implements TagReadListener {
        private SkipIconImageTagReadListener() {
        }

        public void afterHeader(TagReadEvent tagReadEvent) {
            int n2 = JdtUtil.getTransferSyntax(tagReadEvent.getDicomObject());
            if (n2 != 8193 && n2 != 8194) {
                tagReadEvent.setDataReadStatus(2);
            }
        }
    }
}

