/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.AnswerableMessage;
import J2cProtocol.Association;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.MapMessage;
import J2cProtocol.Message;
import J2cProtocol.State;

public class DicomRequestMessage
extends MapMessage
implements AnswerableMessage {
    private static final String SERIES_INSTANCE_UID_KEY = "SeriesInstanceUid";
    private static final String SOP_INSTANCE_UID_KEY = "SopInstanceUid";
    private static final String TEST_MESSAGE = "TestMessage";

    public DicomRequestMessage() {
    }

    public DicomRequestMessage(String string, String string2) {
        this();
        this.setSeriesInstanceUid(string);
        this.setSopInstanceUid(string2);
    }

    public Message createAnswerMessage(Association association) throws J2cProtocolException {
        throw new J2cProtocolException(this.getClass().getName() + " must be sub-classed on the server side");
    }

    public int getCode() {
        return 16;
    }

    public void setSeriesInstanceUid(String string) {
        this.addEntry(SERIES_INSTANCE_UID_KEY, string);
    }

    public void setSopInstanceUid(String string) {
        this.addEntry(SOP_INSTANCE_UID_KEY, string);
    }

    public void setTestMessage(boolean bl2) {
        this.addEntry(TEST_MESSAGE, Boolean.toString(bl2));
    }

    public String getSeriesInstanceUid() {
        return this.getValue(SERIES_INSTANCE_UID_KEY);
    }

    public String getSopInstanceUid() {
        return this.getValue(SOP_INSTANCE_UID_KEY);
    }

    public boolean isTestMessage() {
        String string = this.getValue(TEST_MESSAGE);
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public void validateMessage(State state) throws J2cProtocolException {
        this.validateMessage(state, State.ESTABLISHING_REQUEST);
    }
}

