/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.ImageMessage;
import J2cProtocol.J2cProtocolException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ImageBufferMessage
extends ImageMessage {
    private byte[] mBuffer;
    private int mCurrentBufferLength;

    public ImageBufferMessage(byte[] byArray) {
        this.mBuffer = byArray;
        this.mCurrentBufferLength = 0;
    }

    public ImageBufferMessage(byte[] byArray, int n2, int n3) {
        super(n2);
        this.mBuffer = byArray;
        this.mCurrentBufferLength = n3;
    }

    public byte[] getBufferReference() {
        return this.mBuffer;
    }

    public void setCurrentBufferLength(int n2) {
        this.mCurrentBufferLength = n2;
    }

    public int getCurrentBufferLength() {
        return this.mCurrentBufferLength;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        int n2 = dataInputStream.readUnsignedShort();
        if (n2 < 4) {
            throw new J2cProtocolException("Message length field is invalid (too short)");
        }
        this.setImageIndex(dataInputStream.readInt());
        dataInputStream.readFully(this.getBufferReference(), 0, n2 -= 4);
        this.setCurrentBufferLength(n2);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        dataOutputStream.writeShort(4 + this.getCurrentBufferLength());
        dataOutputStream.writeInt(this.getImageIndex());
        dataOutputStream.write(this.getBufferReference(), 0, this.getCurrentBufferLength());
    }

    public int getLength() {
        return 6 + this.getCurrentBufferLength();
    }
}

