/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.Association;
import J2cProtocol.DisconnectMessage;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.State;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Message {
    public abstract void read(DataInputStream var1) throws IOException, J2cProtocolException;

    public abstract void write(DataOutputStream var1) throws IOException, J2cProtocolException;

    public abstract int getLength();

    public abstract int getCode();

    public void process(Association association) throws J2cProtocolException {
    }

    public void updateAssociationOnInput(Association association) throws J2cProtocolException {
    }

    public void updateAssociationOnOutput(Association association) throws J2cProtocolException {
    }

    protected static void writeString(DataOutputStream dataOutputStream, String string) throws IOException, J2cProtocolException {
        byte[] byArray = string.getBytes();
        if (byArray.length > 65535) {
            throw new J2cProtocolException("String too long for protocol");
        }
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
    }

    protected static int writeStringLength(String string) {
        return string.length() + 2;
    }

    protected static String readString(DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        return new String(byArray);
    }

    public void validateMessage(State state) throws J2cProtocolException {
        this.validateMessage(state, State.DATA_EXCHANGE);
    }

    protected void validateMessage(State state, State state2) throws J2cProtocolException {
        if (state != state2) {
            throw new J2cProtocolException("Association not in expected state for this message type (" + this + "). Current state = [" + state + "], expected state = [" + state2 + "]");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public DisconnectMessage createDisconnectMessage(int n2, Exception exception) {
        return new DisconnectMessage(n2, "Error occured while processing message " + this.toString() + ". " + exception.toString());
    }
}

