/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol.SeriesHeaderParser;

import J2cProtocol.DisplayShutter;
import J2cProtocol.ImageAcquisitionMatrix;
import J2cProtocol.J2cMissingValueException;
import J2cProtocol.SeriesHeaderParser.DisplayShutterNode;
import J2cProtocol.SeriesHeaderParser.ListNode;
import J2cProtocol.SeriesHeaderParser.SimpleTagNode;
import J2cProtocol.XmlSeriesHeaderKeys;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ImageNode
extends SimpleTagNode
implements XmlSeriesHeaderKeys {
    private Map mPercentileMap = new HashMap();
    private String mWindowLevelCentre;
    private String mWindowLevelWidth;
    private String mRescaleIntercept;
    private String mRescaleSlope;
    private String mRowSpacing;
    private String mColumnSpacing;
    private String mPatientOrientationRow;
    private String mPatientOrientationColumn;
    private String[] mPosition = new String[3];
    private String[] mRowVector = new String[3];
    private String[] mColumnVector = new String[3];
    private String mPixelAspectRatioVertical;
    private String mPixelAspectRatioHorizontal;
    private String mImageAcquisitionFrequencyRows;
    private String mImageAcquisitionFrequencyColumns;
    private String mImageAcquisitionPhaseRows;
    private String mImageAcquisitionPhaseColumns;
    private SimpleTagNode mAcquisitionNode = null;
    private DisplayShutterNode mImageShutterNode = new DisplayShutterNode();
    private ListNode mScanOptions = new ListNode("PARAM");
    private ListNode mFilterMaterials = new ListNode("MATERIAL");

    public Vector getScanOptions() {
        return this.mScanOptions.getItems();
    }

    public Vector getFilterMaterials() {
        return this.mFilterMaterials.getItems();
    }

    public String getPercentile(String string) {
        return (String)this.mPercentileMap.get(string);
    }

    public String getWindowLevelCentre() {
        return this.mWindowLevelCentre;
    }

    public String getWindowLevelWidth() {
        return this.mWindowLevelWidth;
    }

    public String getRescaleIntercept() {
        return this.mRescaleIntercept;
    }

    public String getRescaleSlope() {
        return this.mRescaleSlope;
    }

    public String getRowSpacing() {
        return this.mRowSpacing;
    }

    public String getColumnSpacing() {
        return this.mColumnSpacing;
    }

    public String getPatientOrientationRow() {
        return this.mPatientOrientationRow;
    }

    public String getPatientOrientationColumn() {
        return this.mPatientOrientationColumn;
    }

    public String[] getPosition() {
        return this.mPosition;
    }

    public String[] getRowVector() {
        return this.mRowVector;
    }

    public String[] getColumnVector() {
        return this.mColumnVector;
    }

    public ImageAcquisitionMatrix getAcquisitionMatrix() {
        try {
            return new ImageAcquisitionMatrix(Integer.parseInt(this.mImageAcquisitionFrequencyRows), Integer.parseInt(this.mImageAcquisitionFrequencyColumns), Integer.parseInt(this.mImageAcquisitionPhaseRows), Integer.parseInt(this.mImageAcquisitionPhaseColumns));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getPixelAspectRatioVertical() {
        return this.mPixelAspectRatioVertical;
    }

    public String getPixelAspectRatioHorizontal() {
        return this.mPixelAspectRatioHorizontal;
    }

    void processTagValue(String[] stringArray, int n2, String string) {
        String string2 = stringArray[n2 - 1];
        String string3 = stringArray[n2 - 2];
        if (stringArray[2].equals("SHUTTER")) {
            this.mImageShutterNode.processTagValue(stringArray, n2, string);
            return;
        }
        switch (n2) {
            case 3: {
                this.saveSimpleTag(stringArray, n2, string);
                break;
            }
            case 4: {
                if (string3.equals("PERCENTILES")) {
                    this.mPercentileMap.put(string2, string);
                    break;
                }
                if (string3.equals("WINDOWLEVEL")) {
                    this.saveWindowLevelValue(string2, string);
                    break;
                }
                if (string3.equals("RESCALE")) {
                    this.saveRescaleValue(string2, string);
                    break;
                }
                if (string3.equals("PIXELSPACING")) {
                    this.savePixelSpacingValue(string2, string);
                    break;
                }
                if (string3.equals("POSITION")) {
                    this.saveVectorValue(this.mPosition, string2, string);
                    break;
                }
                if (string3.equals("PATIENTORIENTATION")) {
                    this.savePatientOrientationValue(string2, string);
                    break;
                }
                if (string3.equals("ACQUISITION")) {
                    this.saveAcquisitionNodeValue(stringArray, n2, string);
                    break;
                }
                if (string3.equals("ACQUISITIONMATRIX")) {
                    this.saveAcquisitionMatrix(string2, string);
                    break;
                }
                if (string3.equals("PIXELASPECTRATIO")) {
                    this.savePixelAspectRatio(string2, string);
                    break;
                }
                if (string3.equals("SCANOPTIONS")) {
                    this.mScanOptions.processTagValue(stringArray, n2, string);
                    break;
                }
                if (!string3.equals("FILTERMATERIALS")) break;
                this.mFilterMaterials.processTagValue(stringArray, n2, string);
                break;
            }
            case 5: {
                if (!stringArray[n2 - 3].equals("ORIENTATION")) break;
                if (string3.equals("ROWVECTOR")) {
                    this.saveVectorValue(this.mRowVector, string2, string);
                    break;
                }
                if (!string3.equals("COLUMNVECTOR")) break;
                this.saveVectorValue(this.mColumnVector, string2, string);
            }
        }
    }

    private void saveWindowLevelValue(String string, String string2) {
        if (string.equals("CENTRE")) {
            this.mWindowLevelCentre = string2;
        } else if (string.equals("WIDTH")) {
            this.mWindowLevelWidth = string2;
        }
    }

    private void saveRescaleValue(String string, String string2) {
        if (string.equals("INTERCEPT")) {
            this.mRescaleIntercept = string2;
        } else if (string.equals("SLOPE")) {
            this.mRescaleSlope = string2;
        }
    }

    private void savePixelSpacingValue(String string, String string2) {
        if (string.equals("ROW")) {
            this.mRowSpacing = string2;
        } else if (string.equals("COLUMN")) {
            this.mColumnSpacing = string2;
        }
    }

    private void savePatientOrientationValue(String string, String string2) {
        if (string.equals("ROW")) {
            this.mPatientOrientationRow = string2;
        } else if (string.equals("COLUMN")) {
            this.mPatientOrientationColumn = string2;
        }
    }

    private void saveVectorValue(String[] stringArray, String string, String string2) {
        if (string.equals("X")) {
            stringArray[0] = string2;
        } else if (string.equals("Y")) {
            stringArray[1] = string2;
        } else if (string.equals("Z")) {
            stringArray[2] = string2;
        }
    }

    private void saveAcquisitionMatrix(String string, String string2) {
        if (string.equals("FREQUENCYROWS")) {
            this.mImageAcquisitionFrequencyRows = string2;
        } else if (string.equals("FREQUENCYCOLUMNS")) {
            this.mImageAcquisitionFrequencyColumns = string2;
        } else if (string.equals("PHASEROWS")) {
            this.mImageAcquisitionPhaseRows = string2;
        } else if (string.equals("PHASECOLUMNS")) {
            this.mImageAcquisitionPhaseColumns = string2;
        }
    }

    private void savePixelAspectRatio(String string, String string2) {
        if (string.equals("VERTICAL")) {
            this.mPixelAspectRatioVertical = string2;
        } else if (string.equals("HORIZONTAL")) {
            this.mPixelAspectRatioHorizontal = string2;
        }
    }

    public DisplayShutter getImageShutter() {
        try {
            return this.mImageShutterNode.getImageShutter();
        }
        catch (J2cMissingValueException j2cMissingValueException) {
            return null;
        }
    }

    private void saveAcquisitionNodeValue(String[] stringArray, int n2, String string) {
        if (this.mAcquisitionNode == null) {
            this.mAcquisitionNode = new SimpleTagNode(4);
        }
        this.mAcquisitionNode.saveSimpleTag(stringArray, n2, string);
    }

    public SimpleTagNode getAcquisitionNode() {
        return this.mAcquisitionNode;
    }
}

