/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.DicomReplyMessage;
import J2cProtocol.DicomRequestMessage;
import J2cProtocol.DisconnectMessage;
import J2cProtocol.Message;

public abstract class State {
    public static final State UNCONNECTED = new State("UNCONNECTED"){

        State getNextState(Message message) {
            return ESTABLISHING_CONNECTION;
        }
    };
    public static final State ESTABLISHING_CONNECTION = new State("ESTABLISHING_CONNECTION"){

        State getNextState(Message message) {
            return ESTABLISHING_REQUEST;
        }
    };
    public static final State ESTABLISHING_REQUEST = new State("ESTABLISHING_REQUEST"){

        State getNextState(Message message) {
            if (message instanceof DicomRequestMessage || message instanceof DicomReplyMessage) {
                return ESTABLISHING_REQUEST;
            }
            if (message instanceof DisconnectMessage) {
                return ESTABLISHING_REQUEST;
            }
            return SERIES_HEADER_TRANSFER;
        }
    };
    public static final State SERIES_HEADER_TRANSFER = new State("SERIES_HEADER_TRANSFER"){

        State getNextState(Message message) {
            return DATA_EXCHANGE;
        }
    };
    public static final State DATA_EXCHANGE = new State("DATA_EXCHANGE"){

        State getNextState(Message message) {
            return DATA_EXCHANGE;
        }
    };
    private String mState;

    private State() {
    }

    private State(String string) {
        this.mState = string;
    }

    abstract State getNextState(Message var1);

    public String toString() {
        return this.mState;
    }
}

