/*
 * Decompiled with CFR 0.152.
 */
package Notification;

import FileUtilities.FileNaming;
import FileUtilities.FileOperations;
import Notification.Notification;
import Notification.NotificationSender;
import Notification.NotificationSeverity;
import Notification.NotificationType;
import Notification.TracerNotification;
import Notification.TransferMode;
import StringUtilities.PrintfFormat;
import StringUtilities.StringEscape;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class LocalNotificationSender
implements NotificationSender {
    private static final File DEFAULT_NOTIFICATION_DIR = new File("/var/spool/Intelerad/notifierMessages/");
    private static final File DEFAULT_NOTIFICATION_LOG = new File("/var/log/PACS/Notify.log");
    private File mNotificationDir;
    private File mNotificationLog;

    public LocalNotificationSender() {
        this(DEFAULT_NOTIFICATION_DIR, DEFAULT_NOTIFICATION_LOG);
    }

    LocalNotificationSender(File file, File file2) {
        this.mNotificationDir = file;
        this.mNotificationLog = file2;
        FileOperations.createDirectory(this.mNotificationDir.getPath());
    }

    public void send(Notification notification) {
        this.writeXml(notification);
        this.logNotification(notification);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXml(Notification notification) {
        File file = null;
        try {
            Object object;
            file = File.createTempFile(notification.getSubsystem(), ".notifier", this.mNotificationDir);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            outputStreamWriter.write("<LOG_EVENT>\n");
            this.writeElement(outputStreamWriter, "NOTIFICATION_ID", notification.getNotificationId());
            this.writeElement(outputStreamWriter, "HOST_NAME", notification.getHostname());
            this.writeElement(outputStreamWriter, "DATETIME_GMT", notification.getFormattedGmtTime());
            this.writeElement(outputStreamWriter, "SEVERITY", notification.getSeverity().getName());
            this.writeElement(outputStreamWriter, "DESCRIPTION", notification.getDescription());
            this.writeElement(outputStreamWriter, "SUBSYSTEM", notification.getSubsystem());
            this.writeElement(outputStreamWriter, "TYPE", notification.getNotificationType().getName());
            this.writeElement(outputStreamWriter, "APPLICATION_VERSION", notification.getAppVersion());
            this.writeElement(outputStreamWriter, "PACS_VERSION", notification.getPacsVersion());
            this.writeElement(outputStreamWriter, "TRANSFER_MODE", notification.getTransferMode().getName());
            if (notification.isTracer()) {
                object = (TracerNotification)notification;
                this.writeElement(outputStreamWriter, "DATA_ID", ((TracerNotification)object).getDataId());
                this.writeElement(outputStreamWriter, "DATA_TYPE", ((TracerNotification)object).getDataType());
                this.writeElement(outputStreamWriter, "SOURCE", ((TracerNotification)object).getSource());
                this.writeElement(outputStreamWriter, "DESTINATION", ((TracerNotification)object).getDestination());
            }
            outputStreamWriter.write("</LOG_EVENT>\n");
            outputStreamWriter.close();
            object = new File(this.mNotificationDir, FileNaming.baseName(file.getCanonicalPath()) + ".xml");
            FileOperations.moveFile(file, (File)object);
        }
        catch (IOException iOException) {
            this.handleNotificationError(notification, "Unable to write XML file", iOException);
            Notification notification2 = new Notification(notification.getNotifier(), "NOTIFIER", NotificationSeverity.CRITICAL, "Unable to write to XML: " + iOException.getMessage(), NotificationType.FILE_IO, notification.getNotificationId(), TransferMode.NORMAL);
            this.logNotification(notification2);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    private void writeElement(Writer writer, String string, String string2) throws IOException {
        writer.write("<" + string + ">" + StringEscape.getSafeXml(string2) + "</" + string + ">\n");
    }

    private void logNotification(Notification notification) {
        if (!notification.shouldLog()) {
            return;
        }
        try {
            PrintfFormat printfFormat = new PrintfFormat("%-30s");
            String string = printfFormat.sprintf(notification.getHostname());
            printfFormat = new PrintfFormat("%24s");
            String string2 = printfFormat.sprintf(notification.getSubsystem());
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.mNotificationLog, true), true);
            printWriter.println("===============================================================================");
            printWriter.println(notification.getFormattedLocalTime() + "  " + string + string2);
            printWriter.println("Notification Id: " + notification.getNotificationId());
            printWriter.println("Type           : " + notification.getNotificationType().getName());
            printWriter.println("Severity       : " + notification.getSeverity().getName());
            printWriter.println("Description    : " + notification.getDescription());
            printWriter.close();
        }
        catch (IOException iOException) {
            this.handleNotificationError(notification, "Unable to append notification to " + this.mNotificationLog, iOException);
        }
    }

    private void handleNotificationError(Notification notification, String string, Exception exception) {
        System.err.println("===============================================================================");
        System.err.println("ERROR issuing notification: " + string + ": " + exception);
        System.err.println("Notification Id: " + notification.getNotificationId());
        System.err.println("Date/Time      : " + notification.getFormattedLocalTime());
        System.err.println("Subsystem      : " + notification.getSubsystem());
        System.err.println("Severity       : " + notification.getSeverity().getName());
        System.err.println("Description    : " + notification.getDescription());
        System.err.println("AppVersion     : " + notification.getAppVersion());
        System.err.println("PacsVersion    : " + notification.getPacsVersion());
        System.err.println("TransferMode   : " + notification.getTransferMode());
        if (notification.isTracer()) {
            TracerNotification tracerNotification = (TracerNotification)notification;
            System.err.println("DataId         : " + tracerNotification.getDataId());
            System.err.println("Source         : " + tracerNotification.getSource());
            System.err.println("Destination    : " + tracerNotification.getDestination());
        }
        System.err.println("Type           : " + notification.getNotificationType().getName());
    }
}

