/*
 * Decompiled with CFR 0.152.
 */
package Notification;

import DateUtilities.DateStringBuilder;
import Notification.NotificationSeverity;
import Notification.NotificationType;
import Notification.Notifier;
import Notification.TransferMode;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Notification {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Notifier mNotifier;
    private String mHostname;
    private String mSubsystem;
    private NotificationSeverity mSeverity;
    private String mDescription;
    private NotificationType mNotificationType;
    private String mNotificationId;
    private TransferMode mTransferMode;
    private Date mLocalTimestamp;

    public Notification(Notifier notifier, String string, NotificationSeverity notificationSeverity, String string2, NotificationType notificationType, String string3, TransferMode transferMode) {
        this.mNotifier = notifier;
        this.mHostname = notifier.getHostname();
        this.mSubsystem = string;
        this.mSeverity = notificationSeverity;
        this.mDescription = string2;
        this.mNotificationType = notificationType;
        this.mNotificationId = string3;
        this.mTransferMode = transferMode;
        this.mLocalTimestamp = new Date();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Notification)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Notification notification = (Notification)object;
        return this.mSubsystem.equals(notification.mSubsystem) && this.mSeverity.equals(notification.mSeverity) && this.mDescription.equals(notification.mDescription) && this.mNotificationType.equals(notification.mNotificationType) && this.mNotificationId.equals(notification.mNotificationId) && this.mTransferMode.equals(notification.mTransferMode);
    }

    public int hashCode() {
        return this.mSubsystem.hashCode() ^ this.mSeverity.hashCode() ^ this.mDescription.hashCode() ^ this.mNotificationType.hashCode() ^ this.mNotificationId.hashCode() ^ this.mTransferMode.hashCode();
    }

    public Notifier getNotifier() {
        return this.mNotifier;
    }

    boolean isTracer() {
        return false;
    }

    boolean shouldLog() {
        return this.mNotificationType != NotificationType.APPLICATION_DATA;
    }

    public String getSubsystem() {
        return this.mSubsystem;
    }

    public String getAppVersion() {
        return this.mNotifier.getAppVersion();
    }

    public String getPacsVersion() {
        return this.mNotifier.getPacsVersion();
    }

    public NotificationSeverity getSeverity() {
        return this.mSeverity;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public NotificationType getNotificationType() {
        return this.mNotificationType;
    }

    public String getNotificationId() {
        return this.mNotificationId;
    }

    public TransferMode getTransferMode() {
        return this.mTransferMode;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public Date getTimestamp() {
        return this.mLocalTimestamp;
    }

    public String getFormattedLocalTime() {
        return DATE_FORMAT.format(this.mLocalTimestamp);
    }

    public String getFormattedGmtTime() {
        return DateStringBuilder.formatDate(DateStringBuilder.getDateTimeGmtMs(this.mLocalTimestamp));
    }

    void setDescription(String string) {
        this.mDescription = string;
    }
}

