/*
 * Decompiled with CFR 0.152.
 */
package Notification;

import DataStructures.WorkQueue;
import Notification.Notification;
import Notification.NotificationSender;
import RuntimeTool.Debug;
import RuntimeTool.DebugManager;

public class RemoteNotificationSender
implements NotificationSender {
    private WorkQueue mQueue;

    public RemoteNotificationSender(WorkQueue workQueue) {
        this.mQueue = workQueue;
    }

    public void send(Notification notification) {
        if (notification.isTracer()) {
            throw new IllegalArgumentException("tracer notifications not handled");
        }
        Debug debug = DebugManager.getDefault();
        debug.printTrace("Queuing remote notification " + notification.getNotificationId());
        if (!this.mQueue.addWork(notification)) {
            debug.printWarning("Remote notification queue full -- dropping notification");
        }
    }

    public void close() {
        this.mQueue.close();
    }
}

