/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Data;

import DataModels.SearchFramework.SeriesLocation;
import PatientSearchLibrary.Data.BasicData;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Data.Study;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Series
extends BasicData {
    private final String DEFAULT_STRING_VALUE = "";
    private static Map mAllowedKeys = new IdentityHashMap();
    private Study mStudy;

    public Series(String string, Study study) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        String string8 = stringTokenizer.nextToken();
        String string9 = stringTokenizer.nextToken();
        this.mData.put("SerInsUID", string2);
        this.mData.put("PName", string3);
        this.mData.put("PatID", string4);
        this.mData.put("SerDate", string5);
        this.mData.put("Mod", string6);
        this.mData.put("SerNum", string7);
        this.mData.put("Image%", string8);
        this.mData.put("SerDes", string9);
        this.mData.put("Status", Status.UNKNOWN);
        this.mStudy = study;
    }

    public Series(Map map, Study study) {
        this.checkMap(map, mAllowedKeys);
        this.mData.putAll(map);
        this.mStudy = study;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.mData.put("SerDate", BasicData.formatDateTime(date));
        } else {
            this.mData.put("SerDate", "");
        }
    }

    public Study getStudy() {
        return this.mStudy;
    }

    public void setOffline(boolean bl2) {
        this.mData.put("Offline", new Boolean(bl2));
    }

    public void setSeriesLocation(SeriesLocation seriesLocation) {
        if (seriesLocation == null) {
            this.mData.remove("SeriesLocation");
        } else {
            this.mData.put("SeriesLocation", seriesLocation);
        }
    }

    public SeriesLocation getSeriesLocation() {
        return (SeriesLocation)this.mData.get("SeriesLocation");
    }

    public boolean isLocationEmpty() {
        return this.getSeriesLocation() == null;
    }

    public void setStatus(Status status) {
        this.mData.put("Status", status);
    }

    public String getUidKey() {
        return "SerInsUID";
    }

    public String getSeriesUid() {
        return (String)this.getValue("SerInsUID");
    }

    public String getPatientName() {
        return (String)this.getValue("PName");
    }

    public String getPatientId() {
        return (String)this.getValue("PatID");
    }

    public String getModality() {
        return (String)this.getValue("Mod");
    }

    public int getImageCount() {
        return Integer.parseInt((String)this.getValue("Image%"));
    }

    public String getSeriesDescription() {
        return (String)this.getValue("SerDes");
    }

    public boolean getOffline() {
        return (Boolean)this.getValue("Offline");
    }

    public Status getStatus() {
        return (Status)this.getValue("Status");
    }

    public boolean equals(Object object) {
        if (!(object instanceof Series)) {
            return false;
        }
        return this.getSeriesUid().equals(((Series)object).getSeriesUid());
    }

    public int hashCode() {
        return this.getSeriesUid().hashCode();
    }

    public String toString() {
        return this.getSeriesDescription() + ": " + this.getSeriesUid() + ", location: " + this.getSeriesLocation();
    }

    static {
        mAllowedKeys.put("SerInsUID", String.class);
        mAllowedKeys.put("PName", String.class);
        mAllowedKeys.put("PatID", String.class);
        mAllowedKeys.put("SerDate", String.class);
        mAllowedKeys.put("Mod", String.class);
        mAllowedKeys.put("SerNum", String.class);
        mAllowedKeys.put("Image%", String.class);
        mAllowedKeys.put("SerDes", String.class);
        mAllowedKeys.put("Offline", String.class);
        mAllowedKeys.put("Status", Status.class);
        mAllowedKeys.put("SeriesLocation", SeriesLocation.class);
    }

    public static class Key {
        public static final String SERIES_INSTANCE_UID = "SerInsUID";
        public static final String DISPLAYED_PATIENT_NAME = "PName";
        public static final String PATIENT_ID = "PatID";
        public static final String SERIES_DATE_TIME = "SerDate";
        public static final String MODALITY = "Mod";
        public static final String SERIES_ID = "SerNum";
        public static final String NUMBER_OF_IMAGES = "Image%";
        public static final String SERIES_DESCRIPTION = "SerDes";
        public static final String OFFLINE = "Offline";
        public static final String STATUS = "Status";
        public static final String SERIES_LOCATION = "SeriesLocation";
    }
}

