/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Util.GuiUtilities;
import PatientSearchLibrary.Gui.GenericResultPane;
import PatientSearchLibrary.Gui.ResultTable;
import PatientSearchLibrary.Gui.RetrievalStatusListener;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.View.ViewSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class PatientSearchActionHandler {
    private final ResultTable mResultTable;
    private final GenericResultPane mResultPane;

    public PatientSearchActionHandler(ActionEvent actionEvent) {
        this.mResultTable = this.determineResultTable(actionEvent);
        this.mResultPane = this.determineResultPane();
    }

    private GenericResultPane determineResultPane() {
        Container container = SwingUtilities.getAncestorOfClass(GenericResultPane.class, this.mResultTable);
        if (container == null) {
            throw new IllegalStateException("No GenericResultPane found. Exactly what are we being invoked on?");
        }
        return (GenericResultPane)container;
    }

    private ResultTable determineResultTable(ActionEvent actionEvent) {
        Component component = GuiUtilities.getAncestorOfClass((Component)actionEvent.getSource(), ResultTable.class);
        if (component == null) {
            throw new IllegalStateException("No ResultTable found. Exactly what are we being invoked on?");
        }
        return (ResultTable)component;
    }

    public ViewSet getViewSet() {
        return this.mResultTable.getSelection();
    }

    public RetrievalStatusListener createRetrievalStatusListener() {
        return new RetrievalStatusListener(){

            public void updateRetrievalStatus() {
                PatientSearchActionHandler.this.mResultPane.updateRetrievalStatus();
            }
        };
    }

    public SearchSession getSearchSession() {
        return this.mResultPane.getSession();
    }

    public Frame getParentFrame() {
        return (Frame)SwingUtilities.getWindowAncestor(this.mResultPane);
    }
}

