/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Util.SwingWorker;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Gui.ViewWorker;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.View.SeriesViewer;
import PatientSearchLibrary.View.ViewSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RelatedSeriesWorker
extends SwingWorker {
    private SearchSession mSession;
    private Set mPatientIds;
    private SeriesViewer mSeriesViewer;
    private ViewWorker mViewWorker;
    private List mRelatedSeries;
    private String mErrorDetails = null;
    private boolean mNoExtendSession;

    public RelatedSeriesWorker(SearchSession searchSession, ViewSet viewSet, SeriesViewer seriesViewer, ViewWorker viewWorker, List list) {
        this(searchSession, RelatedSeriesWorker.getPatientIdSet(viewSet), seriesViewer, viewWorker, list, false);
    }

    public RelatedSeriesWorker(SearchSession searchSession, Set set, SeriesViewer seriesViewer, ViewWorker viewWorker, boolean bl2) {
        this(searchSession, set, seriesViewer, viewWorker, null, bl2);
    }

    public RelatedSeriesWorker(SearchSession searchSession, ViewSet viewSet, SeriesViewer seriesViewer, ViewWorker viewWorker) {
        this(searchSession, viewSet, seriesViewer, viewWorker, null);
    }

    private RelatedSeriesWorker(SearchSession searchSession, Set set, SeriesViewer seriesViewer, ViewWorker viewWorker, List list, boolean bl2) {
        this.mSession = searchSession;
        this.mPatientIds = set;
        this.mSeriesViewer = seriesViewer;
        this.mViewWorker = viewWorker;
        this.mRelatedSeries = list;
        this.mNoExtendSession = bl2;
    }

    public Object construct() {
        if (this.mRelatedSeries == null) {
            GlobalState.trace("RelatedSeriesWorker: Searching for all related series");
            this.findAllRelatedSeries();
        }
        try {
            GlobalState.trace("RelatedSeriesWorker: Waiting for ViewWorker to finish");
            this.mViewWorker.waitUntilFinished();
            GlobalState.trace("RelatedSeriesWorker: ViewWorker is done!");
        }
        catch (InterruptedException interruptedException) {
            GlobalState.error("RelatedSeriesWorker construct() interrupted while waiting for ViewWorker to finish", interruptedException);
        }
        return null;
    }

    private void findAllRelatedSeries() {
        this.mRelatedSeries = new ArrayList();
        GlobalState.trace("RelatedSeriesWorker: Searching all studies of patients in ViewSet");
        SearchClient searchClient = SearchClient.searchAllStudiesForPatients(this.mSession, this.mPatientIds, this.mNoExtendSession);
        List list = searchClient.getSearchResults();
        if (searchClient.getResultCode() != 0) {
            this.mErrorDetails = searchClient.getErrorDetails();
            GlobalState.error("SearchClient returned with result code other than OK: " + searchClient.getResultCode());
            GlobalState.error("SearchClient message details: " + this.mErrorDetails);
            return;
        }
        GlobalState.trace("RelatedSeriesWorker: Search returned");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Study study = (Study)iterator.next();
            Iterator iterator2 = study.getSeriesMap().values().iterator();
            while (iterator2.hasNext()) {
                Series series = (Series)iterator2.next();
                this.mRelatedSeries.add(series);
            }
        }
    }

    private static Set getPatientIdSet(ViewSet viewSet) {
        GlobalState.trace("RelatedSeriesWorker: Getting set of patientIds in ViewSet");
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        Iterator iterator = viewSet.getSelectedSeries().iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            linkedHashSet.add(series.getValue("PatID"));
        }
        return linkedHashSet;
    }

    public void finished() {
        if (this.mViewWorker.isDataLoaded()) {
            if (this.mErrorDetails != null) {
                this.mSeriesViewer.showError("Error searching for related series. Study/Series menu not updated. Details: " + this.mErrorDetails);
            } else {
                this.mSeriesViewer.setRelatedSeries(this.mRelatedSeries);
            }
        }
    }
}

