/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import PatientSearchLibrary.Gui.ErrorDisplayer;
import PatientSearchLibrary.Gui.GenericResultPane;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchExtender;
import PatientSearchLibrary.Gui.PatientSearchPane;
import PatientSearchLibrary.Gui.RelatedSeriesWorker;
import PatientSearchLibrary.Gui.RetrievalStatusListener;
import PatientSearchLibrary.Gui.SearchPerformer;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Gui.ViewWorker;
import PatientSearchLibrary.Retrieve.Retriever;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.View.LoadRequestType;
import PatientSearchLibrary.View.SeriesViewer;
import PatientSearchLibrary.View.ViewSet;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;

public class ResultPane
extends GenericResultPane
implements ActionListener,
RetrievalStatusListener,
ErrorDisplayer {
    public static final String LIST_ALL_STUDIES = "List all studies for patient";
    private JFrame mFrame;
    private Retriever mRetriever;
    private SeriesViewer mSeriesViewer;
    private PatientSearchPane mPatientSearchPane;

    public ResultPane(JFrame jFrame, PatientSearchExtender patientSearchExtender, SearchSession searchSession, List list, Map map, Map map2, SeriesViewer seriesViewer, PatientSearchPane patientSearchPane, Retriever retriever) {
        super(searchSession, patientSearchExtender);
        this.mFrame = jFrame;
        this.mSeriesViewer = seriesViewer;
        this.mPatientSearchPane = patientSearchPane;
        this.mRetriever = retriever;
        this.guiInit(list, map, map2);
    }

    private void guiInit(List list, Map map, Map map2) {
        this.setBorder(new EmptyBorder(0, 8, 8, 8));
        this.setLayout(new BorderLayout());
        this.initStudyTable(list, ResultPane.getStudyColumns(map));
        this.initSeriesTable(ResultPane.getSeriesColumns(map2));
        this.initSplitPane();
        this.add(this.mSplitPane);
        this.mRetriever.registerRetrievalStatusListener(this);
        this.mFrame.addWindowListener(new WindowHandler());
        this.mSplitPane.addPropertyChangeListener(new PropertyChangeHandler());
    }

    protected JPopupMenu createStudyMenu() {
        JPopupMenu jPopupMenu = super.createStudyMenu();
        JMenuItem jMenuItem = new JMenuItem(LIST_ALL_STUDIES, PATIENT_ICON);
        jMenuItem.setActionCommand("LIST_STUDIES_FOR_PATIENT");
        jMenuItem.addActionListener(this);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem);
        this.extendMenu(PatientSearchExtender.PatientMenuType.STUDY_EXTRAS, jPopupMenu);
        return jPopupMenu;
    }

    protected JPopupMenu createSeriesMenu(ActionListener actionListener) {
        JPopupMenu jPopupMenu = super.createSeriesMenu(actionListener);
        this.extendMenu(PatientSearchExtender.PatientMenuType.SERIES_EXTRAS, jPopupMenu);
        return jPopupMenu;
    }

    protected void viewData(ViewSet viewSet, LoadRequestType loadRequestType) {
        ViewWorker viewWorker = new ViewWorker(this.getSession(), this.mFrame, viewSet, this.mSeriesViewer, loadRequestType, this.mRetriever, this);
        RelatedSeriesWorker relatedSeriesWorker = new RelatedSeriesWorker(this.getSession(), viewSet, this.mSeriesViewer, viewWorker);
        viewWorker.start();
        relatedSeriesWorker.start();
    }

    public void showError(String string) {
        MultiMonitorOptionDialog.showMessageDialog(this.mFrame, string, "Patient Search", 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = ((JMenuItem)actionEvent.getSource()).getActionCommand();
        if ("LIST_STUDIES_FOR_PATIENT".equals(string)) {
            this.listAllStudiesForPatient();
        }
    }

    private void listAllStudiesForPatient() {
        Object object;
        GenericResultPane.StudyTableModel studyTableModel = (GenericResultPane.StudyTableModel)this.mStudyTable.getModel();
        int[] nArray = this.mStudyTable.getSelectedRows();
        String string = (String)studyTableModel.getStudy(nArray[0]).getValue("PatID");
        boolean bl2 = true;
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            object = (String)studyTableModel.getStudy(nArray[i2]).getValue("PatID");
            if (string.equals(object)) continue;
            bl2 = false;
            break;
        }
        if (!bl2) {
            this.showError("More than one patient selected");
            return;
        }
        final String string2 = string;
        GlobalState.trace("List all studies for patient " + string);
        object = new SearchPerformer(){
            boolean mNoExtendSession = false;

            public SearchClient performSearch() {
                return SearchClient.searchAllStudiesForPatients(ResultPane.this.getSession(), Collections.singleton(string2), this.mNoExtendSession);
            }

            public void cancelSearch() {
            }

            public void setNoExtendSession(boolean bl2) {
                this.mNoExtendSession = bl2;
            }
        };
        this.mPatientSearchPane.search((SearchPerformer)object, false);
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
                double d2 = (double)ResultPane.this.mSplitPane.getDividerLocation() / ResultPane.this.getSize().getHeight();
                ResultPane.this.getSession().getPreferenceProvider().setResultPaneDividerLocation(d2);
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            double d2 = ResultPane.this.getSession().getPreferenceProvider().getResultPaneDividerLocation();
            ResultPane.this.mSplitPane.setDividerLocation(d2);
        }
    }

    public static class SeriesAction {
        public static final String VIEW = "VIEW_SERIES";
        public static final String VIEW_IN_NEW_WINDOW = "VIEW_SERIES_IN_NEW_WINDOW";
        public static final String ADD = "ADD_SERIES";
    }

    public static class StudyAction {
        public static final String VIEW = "VIEW_STUDIES";
        public static final String VIEW_IN_NEW_WINDOW = "VIEW_STUDIES_IN_NEW_WINDOW";
        public static final String ADD = "ADD_STUDIES";
        public static final String LIST_STUDIES_FOR_PATIENT = "LIST_STUDIES_FOR_PATIENT";
    }
}

